/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtcc.tddc.domain.gis.esm.Feature;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.Dict;
import cn.gtmap.gtcc.tddc.service.clients.gis.data.search.EsAttributeQueryClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.DictClient;
import cn.gtmap.gtcc.tddc.utils.Constant;
import cn.gtmap.gtcc.tddc.utils.Utils;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/index"})
public class IndexQueryRestController {
    @Autowired
    EsAttributeQueryClient esAttributeQueryClient;
    @Autowired
    DictClient dictClient;
    private final String INDEX = "index";
    private final String REGION_CODE = "regionCode";
    private final String INDEX_REGION_CODE = "REGION_CODE";
    private final String P_C_CODE = "00";

    @GetMapping(value={"/attribute/query"})
    Page<Feature> attrQuery(@RequestParam Map<String, String> params) {
        boolean enableSplitIndex;
        if (!params.containsKey("index")) {
            return null;
        }
        String index = MapUtils.getString(params, (Object)"index");
        params.remove("index");
        String regionCode = MapUtils.getString(params, (Object)"regionCode");
        Dict dict = this.dictClient.findValueByKey("enable_split_index");
        boolean bl = enableSplitIndex = dict == null || StringUtils.isEmpty((String)dict.getValue()) ? false : Boolean.valueOf(dict.getValue());
        if (StringUtils.isNotEmpty((String)regionCode) && enableSplitIndex) {
            params.put("REGION_CODE", this.prepareCode(regionCode));
        }
        params.remove("regionCode");
        Page pager = this.esAttributeQueryClient.matchPhraseAndQuery(params, index);
        return pager;
    }

    private String prepareCode(String regionCode) {
        String temp = regionCode;
        if (regionCode.length() == 6) {
            while (temp.endsWith("00")) {
                temp = temp.substring(0, temp.length() - 2);
            }
        } else if (regionCode.length() == 9) {
            if (Utils.judgeRegionLevel((Integer)Constant.CITY, (String)regionCode)) {
                temp = temp.substring(0, Constant.CITY);
            } else if (Utils.judgeRegionLevel((Integer)Constant.AREA, (String)regionCode)) {
                temp = temp.substring(0, Constant.AREA);
            }
        }
        return temp;
    }
}

