/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtcc.gis.resource.ui.service.GyydDataService;
import cn.gtmap.gtcc.gis.resource.ui.service.JsydDataService;
import cn.gtmap.gtcc.tddc.domain.gis.esm.Feature;
import cn.gtmap.gtcc.tddc.service.clients.gis.data.search.EsAttributeQueryClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/heat"})
public class HeatDataController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GyydDataService gyydDataService;
    private final JsydDataService jsydDataService;
    private final EsAttributeQueryClient esAttrQueryClient;

    @Autowired
    public HeatDataController(GyydDataService gyydDataService, JsydDataService jsydDataService, EsAttributeQueryClient esAttrQueryClient) {
        this.gyydDataService = gyydDataService;
        this.jsydDataService = jsydDataService;
        this.esAttrQueryClient = esAttrQueryClient;
    }

    @RequestMapping(value={"/{type}"}, method={RequestMethod.POST, RequestMethod.GET})
    public Map getGyydStatData(@PathVariable String type, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        HashMap ret = Maps.newHashMap();
        try {
            List data = Lists.newArrayList();
            if ("gyyd".equalsIgnoreCase(type)) {
                data = this.gyydDataService.statByXzq();
            } else if ("jsyd".equalsIgnoreCase(type)) {
                data = this.jsydDataService.statByXzq();
            }
            ret.put("type", type);
            ret.put("data", data);
            return ret;
        }
        catch (Exception e) {
            this.logger.error("fetch [{}] data error[ {} ] ", (Object)type, (Object)e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/geo"}, method={RequestMethod.POST, RequestMethod.GET})
    public Feature geoByXzq(@RequestParam String xzqdm) {
        List features = this.esAttrQueryClient.inQuery("XZQDM", new String[]{xzqdm}, "xzq_c");
        if (features != null && features.size() > 0) {
            return (Feature)features.get(0);
        }
        return new Feature();
    }
}

