/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtcc.tddc.domain.gis.cluster.ArcgisServiceDetailResponse;
import cn.gtmap.gtcc.tddc.domain.gis.cluster.ArcgisServicesResponse;
import cn.gtmap.gtcc.tddc.domain.gis.cluster.GisCluster;
import cn.gtmap.gtcc.tddc.domain.gis.cluster.GisNode;
import cn.gtmap.gtcc.tddc.domain.gis.data.search.ResultBean;
import cn.gtmap.gtcc.tddc.service.clients.gis.cluster.GisClusterClient;
import cn.gtmap.gtcc.tddc.service.clients.gis.cluster.GisNodeClient;
import java.security.Principal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/gis-cluster"})
public class GisClusterRestController {
    @Autowired
    private GisClusterClient gisClusterClient;
    @Autowired
    private GisNodeClient gisNodeClient;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/cluster/queryall"})
    public List<GisCluster> queryAllClusters() {
        return this.gisClusterClient.queryAll();
    }

    @PostMapping(value={"/cluster/add"})
    public ResultBean addCluster(@RequestBody GisCluster cluster, Principal principal) {
        if (principal != null) {
            cluster.setCreateUser(principal.getName());
        } else {
            cluster.setCreateUser("sys");
        }
        return this.gisClusterClient.add(cluster);
    }

    @PostMapping(value={"/cluster/update"})
    public ResultBean updateCluster(@RequestBody GisCluster cluster, Principal principal) {
        if (principal != null) {
            cluster.setUpdateUser(principal.getName());
        } else {
            cluster.setUpdateUser("sys");
        }
        return this.gisClusterClient.update(cluster);
    }

    @GetMapping(value={"/cluster/delete"})
    public ResultBean deleteCluster(String id) {
        return this.gisClusterClient.delete(id);
    }

    @GetMapping(value={"/node/querybyclusterid"})
    public List<GisNode> queryNodeByClusterId(@RequestParam(name="clusterid") String clusterId) {
        return this.gisNodeClient.queryByClusterId(clusterId);
    }

    @GetMapping(value={"/node/querybyid"})
    public GisNode queryNodeById(String id) {
        return this.gisNodeClient.queryById(id);
    }

    @PostMapping(value={"/node/add"})
    public ResultBean addNode(@RequestBody GisNode node, Principal principal) {
        if (principal != null) {
            node.setCreateUser(principal.getName());
        } else {
            node.setCreateUser("sys");
        }
        return this.gisNodeClient.add(node);
    }

    @PostMapping(value={"/node/update"})
    public ResultBean updateNode(@RequestBody GisNode node, Principal principal) {
        if (principal != null) {
            node.setUpdateUser(principal.getName());
        } else {
            node.setUpdateUser("sys");
        }
        return this.gisNodeClient.update(node);
    }

    @GetMapping(value={"/node/delete"})
    public ResultBean deleteNode(String id) {
        return this.gisNodeClient.delete(id);
    }

    @GetMapping(value={"/node/{id}/services"})
    public ArcgisServicesResponse services(@PathVariable(value="id") String id, @RequestParam(name="folder", required=false, defaultValue="") String folder) {
        return this.gisNodeClient.services(id, folder);
    }

    @GetMapping(value={"/node/{id}/services/{folder}/{serviceName}.{serviceType}"})
    public ArcgisServiceDetailResponse serviceDetail(@PathVariable(value="id") String id, @PathVariable(name="folder") String folder, @PathVariable(value="serviceName") String serviceName, @PathVariable(value="serviceType") String serviceType) {
        return this.gisNodeClient.service(id, folder, serviceName, serviceType);
    }

    @GetMapping(value={"/node/{id}/services/{serviceName}.{serviceType}"})
    public ArcgisServiceDetailResponse serviceDetail(@PathVariable(value="id") String id, @PathVariable(value="serviceName") String serviceName, @PathVariable(value="serviceType") String serviceType) {
        return this.gisNodeClient.service(id, "", serviceName, serviceType);
    }
}

