/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtcc.gis.core.exception.JSONMessageException;
import cn.gtmap.gtcc.tddc.domain.gis.esm.FeatureCollection;
import cn.gtmap.gtcc.tddc.service.clients.gis.analysis.GISAnalysisClient;
import cn.gtmap.gtcc.tddc.service.clients.gis.analysis.GISMiscClient;
import cn.gtmap.gtcc.tddc.service.clients.gis.data.search.GeoJsonTransformClient;
import cn.gtmap.gtcc.tddc.service.clients.gis.sde.SdeClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Base64;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/analysis"})
public class GISAnalysisController {
    private final GISAnalysisClient gisAnalysisClient;
    private final GISMiscClient gisMiscClient;
    private final GeoJsonTransformClient geoJsonTransformClient;
    private final SdeClient sdeClient;

    @Autowired
    public GISAnalysisController(GISAnalysisClient gisAnalysisClient, GISMiscClient gisMiscClient, GeoJsonTransformClient geoJsonTransformClient, SdeClient sdeClient) {
        this.gisAnalysisClient = gisAnalysisClient;
        this.gisMiscClient = gisMiscClient;
        this.geoJsonTransformClient = geoJsonTransformClient;
        this.sdeClient = sdeClient;
    }

    @PostMapping(value={"/geoCheck"})
    public String geoTopoCheck(@RequestParam String geometry) {
        try {
            return this.gisMiscClient.geoTopoCheck(geometry);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/geoArea"})
    public double geoArea(@RequestParam(value="geometry") String geometry, @RequestParam(defaultValue="4610") String crs) {
        try {
            return this.gisMiscClient.geoArea(geometry, crs);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/tdghsc"})
    public Map tdghscAnalysis(@RequestParam(value="layerType", defaultValue="") String layerType, @RequestParam(value="year", defaultValue="2020") String year, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource, @RequestParam(value="unit", defaultValue="SQUARE", required=false) String unit) {
        try {
            return this.gisAnalysisClient.tdghsc(layerType, year, geometry, outFields, dataSource, unit);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/tdlyxz"})
    public Map tdlyxzAnalysis(@RequestParam(value="dltb", required=false) String dltb, @RequestParam(value="xzdw", required=false) String xzdw, @RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="year", required=false) String year, @RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            return this.gisAnalysisClient.tdlyxz(dltb, xzdw, regionCode, year, geometry, dataSource);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/analysis"})
    public Map analysis(@RequestParam(value="layerName") String layerName, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields") String outFields, @RequestParam(value="titleField") String titleField, @RequestParam(value="fieldAlias") String fieldAlias, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            return this.gisAnalysisClient.common(layerName, geometry, outFields, titleField, fieldAlias, dataSource);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/intersect"})
    public Map intersect(@RequestParam(value="layerName") String layerName, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            return this.gisAnalysisClient.intersect(layerName, geometry, outFields, dataSource);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/query/space"})
    FeatureCollection query(@RequestParam(value="layerName") String layerName, @RequestParam(value="wkt") String wkt, @RequestParam(value="columns", required=false) String[] columns, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            return this.sdeClient.query(layerName, wkt, columns, dataSource);
        }
        catch (Exception ex) {
            throw new JSONMessageException(ex.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/publishGaLayer"})
    public String publish2GA(@RequestBody String params) {
        try {
            JSONObject jobj = JSON.parseObject((String)params);
            byte[] zipFile = this.geoJsonTransformClient.toShpZip(jobj.getString("geometry"));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("file", (Object)Base64.getEncoder().encodeToString(zipFile));
            jsonObject.put("sr", (Object)jobj.getString("sr"));
            String layerUrl = this.gisAnalysisClient.publishToGa(jsonObject.toJSONString());
            return layerUrl;
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/checkGeoJson"})
    public Map checkGeoJson(@RequestBody Map params) {
        try {
            return this.gisMiscClient.checkGeoJson(params);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getLocalizedMessage());
        }
    }
}

