/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtcc.tddc.domain.resource.metadata.display.DisplayCenter;
import cn.gtmap.gtcc.tddc.service.clients.display.DisplayCenterClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@CrossOrigin
@RequestMapping(value={"/rest/display"})
public class DisplayCenterController {
    private static final Logger log = LoggerFactory.getLogger(DisplayCenterController.class);
    @Autowired
    DisplayCenterClient displayCenterClient;
    @Autowired
    private DiscoveryClient discoveryClient;

    @RequestMapping(value={"/query/business/{business}"})
    public List<DisplayCenter> findByBusiness(@PathVariable(value="business") String business) {
        List displayCenterList = null;
        if (StringUtils.isNotBlank((String)business)) {
            try {
                displayCenterList = this.displayCenterClient.findByBusiness(business);
                this.dealDisplayCenterList(displayCenterList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return displayCenterList;
    }

    private void dealDisplayCenterList(List<DisplayCenter> displayCenterList) {
        if (!CollectionUtils.isEmpty(displayCenterList)) {
            // empty if block
        }
    }

    @RequestMapping(value={"/query/business"})
    public Page<DisplayCenter> findByBusiness(@RequestParam(value="business") String business, Pageable pageable) {
        Page displayCenterPage = null;
        if (StringUtils.isNotBlank((String)business)) {
            try {
                displayCenterPage = this.displayCenterClient.findByBusiness(business, pageable);
                if (displayCenterPage != null) {
                    List displayCenterList = displayCenterPage.getContent();
                    this.dealDisplayCenterList(displayCenterList);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return this.displayCenterClient.findByBusiness(business, pageable);
    }

    @RequestMapping(value={"/query/id/{id}"})
    public DisplayCenter findById(@PathVariable(value="id") String id) {
        DisplayCenter displayCenter = null;
        if (StringUtils.isNotBlank((String)id)) {
            try {
                displayCenter = this.displayCenterClient.findById(id);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return displayCenter;
    }

    @RequestMapping(value={"/save"})
    public DisplayCenter save(@RequestBody DisplayCenter displayCenter) {
        if (displayCenter != null && StringUtils.isNotBlank((String)displayCenter.getBusiness())) {
            try {
                if (StringUtils.isBlank((String)displayCenter.getId())) {
                    List displayCenterList = this.displayCenterClient.findByBusiness(displayCenter.getBusiness());
                    if (CollectionUtils.isEmpty((Collection)displayCenterList)) {
                        displayCenter.setSort(Integer.valueOf(0));
                    } else {
                        displayCenter.setSort(Integer.valueOf(displayCenterList.size()));
                    }
                }
                return (DisplayCenter)this.displayCenterClient.save(Arrays.asList(displayCenter)).get(0);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return null;
    }

    @RequestMapping(value={"/save/list"})
    public List<DisplayCenter> save(@RequestBody List<DisplayCenter> displayCenterList) {
        if (!CollectionUtils.isEmpty(displayCenterList)) {
            try {
                return this.displayCenterClient.save(displayCenterList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return null;
    }

    @RequestMapping(value={"/delete/{id}"})
    public String delete(@PathVariable(value="id") String id) {
        String success = "false";
        if (StringUtils.isNotBlank((String)id)) {
            try {
                this.displayCenterClient.delete(id);
                success = "true";
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return success;
    }
}

