/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtcc.tddc.domain.resource.metadata.Dict;
import cn.gtmap.gtcc.tddc.service.clients.resource.DictClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/dict"})
public class DictController {
    @Autowired
    private DictClient dictClient;

    @RequestMapping(value={"/findRootDicts"})
    public Object findRootDicts() {
        return this.dictClient.findRootDicts();
    }

    @RequestMapping(value={"saveDictParams"})
    public Object saveDict(@RequestParam(name="dictParentId", required=false) String dictParentId, @RequestParam(name="dictId", required=false) String dictId, @RequestParam(name="dictKey", required=false) String dictKey, @RequestParam(name="dictValue", required=false) String dictValue, @RequestParam(name="dictTitle", required=false) String dictTitle, @RequestParam(name="isAdd", required=false) boolean isAdd, @RequestParam(name="parentDictKey", required=false) String parentDictKey) {
        if (isAdd) {
            Dict dict = this.dictClient.findValueByKey(dictKey);
            if (dict != null) {
                return false;
            }
            try {
                return this.dictClient.saveDictParams(dictParentId, dictId, dictKey, dictValue, dictTitle, isAdd, parentDictKey);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return this.dictClient.saveDictParams(dictParentId, dictId, dictKey, dictValue, dictTitle, isAdd, parentDictKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/findDefaultDicts"})
    public Object findDefaultDicts(@RequestParam(name="type") String type) {
        Dict dict = this.dictClient.findDictByType(type);
        List dictList = this.dictClient.findDefaultDicts(dict.getId());
        return dictList;
    }

    @RequestMapping(value={"/findDictByKey"})
    public Object findDictByKey(@RequestParam(name="key") String key) {
        return this.dictClient.findDictByType(key);
    }

    @RequestMapping(value={"/getAllDicts"})
    public Object getAllCatalog(@RequestParam(name="type", required=false) String type) {
        List dictList = new ArrayList();
        try {
            dictList = this.dictClient.findDefaultDicts(this.dictClient.findDictByType(type).getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List mapList = this.getDictList(dictList);
        return mapList;
    }

    private List<Map> getDictList(List<Dict> dictList) {
        ArrayList<Map> mapList = new ArrayList<Map>();
        if (!CollectionUtils.isEmpty(dictList)) {
            for (Dict dict : dictList) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("value", dict.getId());
                map.put("_value", dict.getValue());
                map.put("label", dict.getTitle());
                map.put("_key", dict.getDictKey());
                map.put("status", "0");
                map.put("weight", dict.getWeight());
                List childDicts = this.dictClient.findDefaultDicts(dict.getId());
                if (!CollectionUtils.isEmpty((Collection)childDicts)) {
                    map.put("children", this.getDictList(childDicts));
                } else {
                    map.put("children", new ArrayList());
                }
                mapList.add(map);
            }
        }
        return mapList;
    }

    @RequestMapping(value={"/deleteDict/{id}"})
    public String deleteDict(@PathVariable(name="id") String id) {
        String status = "success";
        try {
            this.dictClient.deleteDict(id);
            return status;
        }
        catch (Exception e) {
            e.printStackTrace();
            status = "fail";
            return status;
        }
    }

    @RequestMapping(value={"/updateDict"})
    public Object updateCatalog(@RequestParam(name="nodeArr[]") String[] nodeArr, @RequestParam(name="type") String type) {
        try {
            return this.dictClient.updateDict(nodeArr, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/findDictByDicId"})
    public Object findDictByDicId(@RequestParam(name="dicId") String dicId) {
        return this.dictClient.findDictByDicId(dicId);
    }
}

