/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtcc.tddc.domain.dev.Article;
import cn.gtmap.gtcc.tddc.domain.dev.Comment;
import cn.gtmap.gtcc.tddc.domain.dev.Index;
import cn.gtmap.gtcc.tddc.service.clients.dev.DevDataClient;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@CrossOrigin
@RequestMapping(value={"/rest/dev"})
public class DevDataController {
    private static final Logger log = LoggerFactory.getLogger(DevDataController.class);
    @Autowired
    DevDataClient devDataClient;

    @PostMapping(value={"/catalog/list"})
    public List<Index> getCatalogList(String filter) {
        List indexList = null;
        try {
            indexList = this.devDataClient.getParentIndex();
            if (!CollectionUtils.isEmpty((Collection)indexList)) {
                Collections.sort(indexList);
                this.dealCatalogList(indexList, filter);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return indexList;
    }

    private void dealCatalogList(List<Index> indexList, String filter) {
        if (!CollectionUtils.isEmpty(indexList)) {
            for (int i = 0; i < indexList.size(); ++i) {
                Index index = indexList.get(i);
                List subIndexList = this.devDataClient.getParentIdIndex(index.getId());
                if (CollectionUtils.isEmpty((Collection)subIndexList)) continue;
                if ("true".equals(filter)) {
                    for (int j = subIndexList.size() - 1; j >= 0; --j) {
                        if (!"true".equals(((Index)subIndexList.get(j)).getIsArticle())) continue;
                        subIndexList.remove(j);
                    }
                }
                if (CollectionUtils.isEmpty((Collection)subIndexList)) continue;
                Collections.sort(subIndexList);
                index.setChildren(subIndexList);
                this.dealCatalogList(subIndexList, filter);
            }
        }
    }

    @PostMapping(value={"/catalog/save"})
    public Map<String, Object> saveCatalog(@RequestBody List<Index> indexList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String success = "false";
        try {
            if (!CollectionUtils.isEmpty(indexList)) {
                for (int i = 0; i < indexList.size(); ++i) {
                    Index index = indexList.get(i);
                    index.setSort(i);
                    if (StringUtils.isEmpty((String)index.getId())) {
                        if ("-1".equals(index.getParentid())) {
                            index.setIsroot("true");
                            index.setLevel(0);
                        }
                        String id = this.devDataClient.addIndex(index);
                        index.setId(id);
                        continue;
                    }
                    this.devDataClient.updateIndex(index);
                }
                resultMap.put("indexList", indexList);
            }
            success = "true";
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        resultMap.put("success", success);
        return resultMap;
    }

    @PostMapping(value={"/catalog/delete/{id}"})
    public Map<String, String> deleteCatalog(@PathVariable(value="id") String id) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("success", "false");
        resultMap.put("message", "\u5220\u9664\u5931\u8d25\uff01");
        try {
            if (!StringUtils.isEmpty((String)id)) {
                List indexList = this.devDataClient.getParentIdIndex(id);
                if (CollectionUtils.isEmpty((Collection)indexList)) {
                    Index index = this.devDataClient.getIndxById(id);
                    if (index != null) {
                        List articleList;
                        if ("true".equals(index.getIsArticle()) && !CollectionUtils.isEmpty((Collection)(articleList = this.devDataClient.getArticleByCatgoryId(id)))) {
                            for (Article article : articleList) {
                                List commentList;
                                PageRequest pageRequest = new PageRequest(0, 1000);
                                Page commentPage = this.devDataClient.searchCommentByArticleId(article.getCategoryid(), (Pageable)pageRequest);
                                if (commentPage != null && !CollectionUtils.isEmpty((Collection)(commentList = commentPage.getContent()))) {
                                    for (Comment comment : commentList) {
                                        List replyCommentList;
                                        Page replyCommentPage = this.devDataClient.searchCommentByCommentId(comment.getId(), (Pageable)pageRequest);
                                        if (replyCommentPage != null && !CollectionUtils.isEmpty((Collection)(replyCommentList = replyCommentPage.getContent()))) {
                                            for (Comment replyComment : replyCommentList) {
                                                this.devDataClient.deleteCommentById(replyComment.getId());
                                            }
                                        }
                                        this.devDataClient.deleteCommentById(comment.getId());
                                    }
                                }
                                this.devDataClient.deleteArticleById(article.getId());
                            }
                        }
                        this.devDataClient.deleteIndex(id);
                        List tmpIndexList = this.devDataClient.getParentIdIndex(index.getParentid());
                        if (!CollectionUtils.isEmpty((Collection)tmpIndexList) && index.getSort() < tmpIndexList.size()) {
                            Collections.sort(tmpIndexList);
                            this.saveCatalog(tmpIndexList);
                        }
                    }
                } else {
                    resultMap.put("message", "\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u76ee\u5f55\uff01");
                    return resultMap;
                }
            }
            resultMap.put("success", "true");
            resultMap.put("message", "\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return resultMap;
    }

    @PostMapping(value={"/article/save"})
    public Map<String, String> addArticle(@RequestBody Article article, Principal principal) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String success = "false";
        String message = "\u4fdd\u5b58\u5931\u8d25\uff01";
        try {
            if (StringUtils.isEmpty((String)article.getAnswersid())) {
                Index parentIndex;
                if (principal != null) {
                    article.setAuthor(principal.getName());
                }
                if ((parentIndex = this.devDataClient.getIndxById(article.getCategoryid())) != null) {
                    Index index = new Index();
                    index.setDescription(article.getTitle());
                    index.setLevel(parentIndex.getLevel() + 1);
                    index.setParentid(parentIndex.getId());
                    index.setIsArticle("true");
                    List indexList = this.devDataClient.getParentIdIndex(article.getCategoryid());
                    if (!CollectionUtils.isEmpty((Collection)indexList)) {
                        index.setSort(indexList.size());
                    }
                    String categoryId = this.devDataClient.addIndex(index);
                    article.setCategoryid(categoryId);
                    String id = this.devDataClient.addArticle(article);
                    resultMap.put("id", id);
                    resultMap.put("categoryId", article.getCategoryid());
                }
            } else {
                resultMap.put("id", article.getId());
                Article tmpArticle = this.devDataClient.searchArticle(article.getId());
                if (tmpArticle != null) {
                    resultMap.put("categoryId", tmpArticle.getCategoryid());
                    tmpArticle.setTitle(article.getTitle());
                    tmpArticle.setAuthor(article.getAuthor());
                    tmpArticle.setHtmlcontent(article.getHtmlcontent());
                    this.devDataClient.updateArticleById(tmpArticle);
                    if (article.getCategoryid() != null) {
                        Index currentIndex = this.devDataClient.getIndxById(tmpArticle.getCategoryid());
                        if (!article.getCategoryid().equals(currentIndex.getParentid())) {
                            Index parentIndex = this.devDataClient.getIndxById(article.getCategoryid());
                            currentIndex.setParentid(article.getCategoryid());
                            currentIndex.setLevel(parentIndex.getLevel() + 1);
                            List indexList = this.devDataClient.getParentIdIndex(article.getCategoryid());
                            if (!CollectionUtils.isEmpty((Collection)indexList)) {
                                currentIndex.setSort(indexList.size());
                            } else {
                                currentIndex.setSort(0);
                            }
                        }
                        currentIndex.setDescription(article.getTitle());
                        this.devDataClient.updateIndex(currentIndex);
                    }
                }
            }
            success = "true";
            message = "\u4fdd\u5b58\u6210\u529f\uff01";
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        resultMap.put("success", success);
        resultMap.put("message", message);
        return resultMap;
    }

    @PostMapping(value={"/article/search/{catalogId}"})
    public Map<String, Object> searchArticleByCatalogId(@PathVariable(name="catalogId") String catalogId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Article article;
            List articleList = this.devDataClient.getArticleByCatgoryId(catalogId);
            if (!CollectionUtils.isEmpty((Collection)articleList) && (article = this.devDataClient.searchArticle(((Article)articleList.get(0)).getId())) != null) {
                ArrayList<String> catalogIdList = new ArrayList<String>();
                ArrayList<Index> indexList = new ArrayList<Index>();
                Index index = this.devDataClient.getIndxById(article.getCategoryid());
                if (index != null) {
                    article.setCategoryid(index.getParentid());
                    indexList.add(index);
                    this.getIndexParent(indexList);
                }
                String route = "";
                for (int i = 0; i < indexList.size(); ++i) {
                    Index catalog = (Index)indexList.get(i);
                    if (i < indexList.size() - 1) {
                        catalogIdList.add(catalog.getId());
                    }
                    route = route + "-" + catalog.getSort();
                }
                map.put("route", route);
                map.put("catalog", catalogIdList.toArray());
                map.put("article", article);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return map;
    }

    @PostMapping(value={"/article/search"})
    public Map<String, Object> searchArticle(@RequestParam(value="query") String query, Pageable pageable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("content", null);
        map.put("total", 0);
        if (!StringUtils.isEmpty((String)query)) {
            try {
                Page articlePage = this.devDataClient.getArticleFuzz(query, pageable);
                if (articlePage != null) {
                    ArrayList articleMapList = new ArrayList();
                    map.put("content", articleMapList);
                    map.put("total", articlePage.getTotalElements());
                    List articleList = articlePage.getContent();
                    if (!CollectionUtils.isEmpty((Collection)articleList)) {
                        for (int i = 0; i < articleList.size(); ++i) {
                            Article article = (Article)articleList.get(i);
                            HashMap<String, Object> articleMap = new HashMap<String, Object>();
                            articleMapList.add(articleMap);
                            articleMap.put("article", article);
                            if (StringUtils.isNotBlank((String)article.getCategoryid())) {
                                Index index = this.devDataClient.getIndxById(article.getCategoryid());
                                ArrayList<Index> catalogList = new ArrayList<Index>();
                                catalogList.add(index);
                                this.getIndexParent(catalogList);
                                String route = "";
                                for (Index catalog : catalogList) {
                                    route = route + "-" + catalog.getSort();
                                }
                                articleMap.put("route", route);
                                catalogList.remove(catalogList.size() - 1);
                                articleMap.put("catalogList", catalogList);
                            }
                            article.setTitle(this.getDealString(article.getTitle(), query));
                            String html = article.getHtmlcontent();
                            if (!StringUtils.isNotBlank((String)html)) continue;
                            html = html.replaceAll("[^(a-zA-Z0-9\\u4e00-\\u9fa5\u3001,\uff0c.\u3002\u201c\u201d\"!\uff01%:/{}?\uff1f_=\\[\\])]", "");
                            String tmpQuery = null;
                            int len = 200;
                            int tmpLen = 40;
                            int index = StringUtils.indexOf((String)html, (String)query);
                            if (index == -1) {
                                for (int j = 0; j < query.length() && (index = StringUtils.indexOf((String)html, (String)(tmpQuery = query.charAt(j) + ""))) == -1; ++j) {
                                }
                            }
                            if (index == -1) {
                                html = StringUtils.substring((String)html, (int)0, (int)len);
                            } else {
                                if (tmpQuery == null) {
                                    tmpQuery = query;
                                }
                                html = index <= tmpLen ? StringUtils.left((String)html, (int)len) : (html.length() - index <= len - tmpLen ? StringUtils.right((String)html, (int)len) : StringUtils.substring((String)html, (int)(index - tmpLen), (int)(index + len - tmpLen)));
                                html = StringUtils.replace((String)html, (String)tmpQuery, (String)("<em>" + tmpQuery + "</em>"));
                            }
                            article.setHtmlcontent(html);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return map;
    }

    private String getDealString(String content, String query) {
        if (StringUtils.isNotBlank((String)content)) {
            String tmpQuery = null;
            int index = StringUtils.indexOf((String)content, (String)query);
            if (index == -1) {
                for (int j = 0; j < query.length() && (index = StringUtils.indexOf((String)content, (String)(tmpQuery = query.charAt(j) + ""))) == -1; ++j) {
                }
            }
            if (index != -1) {
                if (tmpQuery == null) {
                    tmpQuery = query;
                }
                content = StringUtils.replace((String)content, (String)tmpQuery, (String)("<em>" + tmpQuery + "</em>"));
            }
        }
        return content;
    }

    private void getIndexParent(List<Index> catalogList) {
        Index parentIndex;
        String parentId;
        if (!(CollectionUtils.isEmpty(catalogList) || StringUtils.isEmpty((String)(parentId = catalogList.get(0).getParentid())) || "-1".equals(parentId) || (parentIndex = this.devDataClient.getIndxById(parentId)) == null)) {
            catalogList.add(0, parentIndex);
            this.getIndexParent(catalogList);
        }
    }

    @PostMapping(value={"/comment/save"})
    public Map<String, Object> addComment(@RequestBody Comment comment, Principal principal) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String success = "false";
        if (StringUtils.isNotBlank((String)comment.getArticleid()) || StringUtils.isNotBlank((String)comment.getReplyid()) && StringUtils.isNotBlank((String)StringUtils.trim((String)comment.getContent()))) {
            try {
                if (principal != null) {
                    comment.setUserid(principal.getName());
                }
                if (StringUtils.isBlank((String)comment.getId())) {
                    String id = this.devDataClient.addComment(comment);
                    map.put("id", id);
                    map.put("createtime", new Date());
                } else {
                    this.devDataClient.updateComment(comment);
                    map.put("id", comment.getId());
                }
                success = "true";
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        map.put("success", success);
        return map;
    }

    @PostMapping(value={"/comment/delete/{commentId}"})
    public String deleteCommentById(@PathVariable(name="commentId") String commentId) {
        String success = "false";
        try {
            List commentList;
            PageRequest pageRequest = new PageRequest(0, 1000);
            Page commentPage = this.devDataClient.searchCommentByCommentId(commentId, (Pageable)pageRequest);
            if (commentPage != null && !CollectionUtils.isEmpty((Collection)(commentList = commentPage.getContent()))) {
                for (Comment comment : commentList) {
                    this.devDataClient.deleteCommentById(comment.getId());
                }
            }
            this.devDataClient.deleteCommentById(commentId);
            success = "true";
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return success;
    }

    @PostMapping(value={"/comment/list/{catalogId}"})
    public Page<Comment> getCommentList(@PathVariable(name="catalogId") String catalogId, Pageable pageable) {
        Page commentPage = null;
        if (StringUtils.isNotBlank((String)catalogId)) {
            try {
                List commentList;
                commentPage = this.devDataClient.searchCommentByArticleId(catalogId, pageable);
                if (commentPage != null && !CollectionUtils.isEmpty((Collection)(commentList = commentPage.getContent()))) {
                    for (int i = 0; i < commentList.size(); ++i) {
                        Comment comment = (Comment)commentList.get(i);
                        PageRequest pageRequest = new PageRequest(0, 1000, pageable.getSort());
                        Page replyCommentPage = this.devDataClient.searchCommentByCommentId(comment.getId(), (Pageable)pageRequest);
                        if (replyCommentPage == null) continue;
                        comment.setChildren(replyCommentPage.getContent());
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return commentPage;
    }

    @PostMapping(value={"/comment/replylist/{commentId}"})
    public Page<Comment> getReplyCommentList(@PathVariable(name="commentId") String commentId, Pageable pageable) {
        Page<Comment> commentPage = null;
        if (StringUtils.isNotBlank((String)commentId)) {
            try {
                return this.devDataClient.searchCommentByCommentId(commentId, pageable);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return commentPage;
    }
}

