/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web.rest;

import cn.gtmap.gtcc.tddc.domain.gis.tpl.Tpl;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.CapableView;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.CatalogView;
import cn.gtmap.gtcc.tddc.domain.resource.dto.resource.ResourceView;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.Catalog;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.Dict;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.SpatialCoverage;
import cn.gtmap.gtcc.tddc.service.clients.resource.CatalogClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.DictClient;
import cn.gtmap.gtcc.tddc.service.clients.resource.ResourceClient;
import cn.gtmap.gtcc.tddc.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/rest/catalog"})
public class CatalogController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_RESOURCE_CATALOG = "RESC";
    public static final String DEFAULT_CG_CATALOG = "CG";
    @Autowired
    private CatalogClient catalogClient;
    @Autowired
    private ResourceClient resourceClient;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private DictClient dictClient;

    @RequestMapping(value={"/findRootCatalog"})
    public Object findRootCatalog() {
        return this.catalogClient.findRootCatalog(DEFAULT_RESOURCE_CATALOG);
    }

    @RequestMapping(value={"/findRootCatalogByParentId/{parentId}"})
    public Object findRootCatalogByParentId(@PathVariable(name="parentId") String parentId) {
        return this.catalogClient.findAllRootCatalog(parentId);
    }

    @RequestMapping(value={"/root/groups"})
    public Map findRootCatalogGroups() {
        return this.catalogClient.findRootCatalogGroups();
    }

    @RequestMapping(value={"/root/getDataDownloadCatalogGroups"})
    public Map getDataDownloadCatalogGroups() {
        return this.catalogClient.getDataDownloadCatalogGroups();
    }

    @RequestMapping(value={"/findChildCatalogById/{id}"})
    public Object findChildCatalogById(@PathVariable(name="id") String id) {
        return this.catalogClient.findChildCatalog(id);
    }

    @RequestMapping(value={"/query/children/{parentId}"})
    public List<CatalogView> findByParentId(@PathVariable(name="parentId") String parentId) {
        return this.catalogClient.findByParentId(parentId);
    }

    @RequestMapping(value={"/getCatalogByType/{type}"})
    public Object getCatalogByType(@PathVariable(name="type") String type) {
        List catalogViewList = this.catalogClient.findAllCatalogByType(type);
        return this.dealCatalog(catalogViewList);
    }

    private List<Map<String, Object>> dealCatalog(List<CatalogView> catalogViewList) {
        if (!CollectionUtils.isEmpty(catalogViewList)) {
            ArrayList<Map<String, Object>> catalogViewMapList = new ArrayList<Map<String, Object>>();
            for (CatalogView catalogView : catalogViewList) {
                HashMap<String, Object> catalogViewMap = new HashMap<String, Object>(16);
                catalogViewMapList.add(catalogViewMap);
                catalogViewMap.put("id", catalogView.getId());
                catalogViewMap.put("label", catalogView.getTitle());
                String code = catalogView.getCode();
                int level = code.length() == 4 ? 2 : 3;
                catalogViewMap.put("code", level);
                List childrenList = catalogView.getChildren();
                if (CollectionUtils.isEmpty((Collection)childrenList)) {
                    catalogViewMap.put("children", new ArrayList());
                    catalogViewMap.put("isCatalogLeaf", "true");
                    continue;
                }
                catalogViewMap.put("children", this.dealCatalog(childrenList));
            }
            return catalogViewMapList;
        }
        return null;
    }

    @RequestMapping(value={"/findCatalogResources/{catalogId}"})
    public Object findCatalogResources(@PathVariable(name="catalogId") String catalogId, Pageable pageable) {
        PageRequest tmpPageable = new PageRequest(0, 100, pageable.getSort());
        Page resourceViewPage = this.resourceClient.findCatalogResources(catalogId, (Pageable)tmpPageable);
        List resourceViewList = resourceViewPage.getContent();
        if (!CollectionUtils.isEmpty((Collection)resourceViewList)) {
            ArrayList resourceMapList = new ArrayList();
            for (ResourceView resourceView : resourceViewList) {
                List capableViewList;
                HashMap<String, Object> resourceMap = new HashMap<String, Object>(16);
                resourceMapList.add(resourceMap);
                resourceMap.put("id", resourceView.getId());
                resourceMap.put("label", resourceView.getTitle());
                resourceMap.put("isResource", "true");
                SpatialCoverage spatialCoverage = resourceView.getSpatialCoverage();
                if (spatialCoverage != null) {
                    resourceMap.put("wkid", spatialCoverage.getWkid());
                }
                if (CollectionUtils.isEmpty((Collection)(capableViewList = resourceView.getCapables()))) continue;
                CapableView capableView = (CapableView)capableViewList.get(0);
                resourceMap.put("type", capableView.getType());
                String url = this.getProxyUrl(resourceView.getId(), capableView.getType().name());
                if (StringUtils.isBlank((String)url)) {
                    try {
                        Map map = (Map)capableView.getInfo();
                        if (map != null && map.get("url") != null) {
                            url = map.get("url").toString();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (StringUtils.isBlank((String)url)) {
                    url = capableView.getUrl();
                }
                resourceMap.put("url", url);
            }
            return resourceMapList;
        }
        return null;
    }

    @RequestMapping(value={"/getAllCatalog"})
    public Object getAllCatalog(@RequestParam(name="type", required=false) String type, @RequestParam(name="serverCatalog", required=false) String serverCatalog) {
        if (!DEFAULT_CG_CATALOG.equals(type)) {
            List catalogList = new ArrayList();
            try {
                catalogList = this.catalogClient.findAllCatalogByType(type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List mapList = this.getCatalogViewList(catalogList, serverCatalog);
            return mapList;
        }
        return this.catalogClient.findAllCatalogByType(type);
    }

    @RequestMapping(value={"/findParentByChild"})
    public List findParentByChild(@RequestParam(name="id", required=false) String id) {
        return this.catalogClient.findParentByChild(id);
    }

    @PostMapping(value={"/saveCatalog"})
    public Object saveCatalog(@RequestBody Catalog catalog) {
        try {
            return this.catalogClient.saveCatalog(catalog);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/deleteCatalogById/{id}"})
    public String findRegionChild(@PathVariable(name="id") String id) {
        List stringList = null;
        String status = "success";
        try {
            stringList = this.catalogClient.findCatRefList(id);
            if (!CollectionUtils.isEmpty((Collection)stringList)) {
                this.catalogClient.deleteRef(id);
            }
            this.catalogClient.deleteCatalog(id);
            return status;
        }
        catch (Exception e) {
            e.printStackTrace();
            status = "fail";
            return status;
        }
    }

    @RequestMapping(value={"/saveCatalogParams"})
    public Object saveCatalogParams(@RequestParam(name="parentId", required=false) String parentId, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="catalogId", required=false) String catalogId, @RequestParam(name="catalogType", required=false) String catalogType, @RequestParam(name="catalogTitle", required=false) String catalogTitle, @RequestParam(name="catalogRemark", required=false) String catalogRemark, @RequestParam(name="isAdd", required=false) boolean isAdd, @RequestParam(name="dicId", required=false) String dicId) {
        try {
            return this.catalogClient.saveCatalogParams(parentId, parentType, catalogId, catalogType, catalogTitle, catalogRemark, isAdd, dicId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/deleteCatalogByType/{type}"})
    public String deleteCatalogByType(@PathVariable(name="type") String type) {
        String status = "success";
        try {
            this.catalogClient.deleteCatalogByType(type);
        }
        catch (Exception e) {
            e.printStackTrace();
            status = "fail";
        }
        return status;
    }

    @RequestMapping(value={"/associate/catalogAndResource"})
    public Object associateCatalogAndResources(@RequestParam(name="catalogId") String catalogId, @RequestParam(name="resources[]") String[] resourceIds, @RequestParam(name="replaceAll", required=false) boolean replace) {
        try {
            return this.catalogClient.associateCatalogAndResources(catalogId, resourceIds, replace);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/remove/resource/ref"})
    public Object removeCatalogAndResources(@RequestParam(name="catalogId") String catalogId, @RequestParam(name="resources[]") String[] resourceIds) {
        try {
            return this.catalogClient.removeCatalogAndResources(catalogId, resourceIds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GetMapping(value={"/sourcesCount"})
    public Map<String, Integer> getSourcesCountByType() {
        return this.catalogClient.getSourcesCountByType();
    }

    private List<Map> getCatalogViewList(List<CatalogView> catalogViewList, String serverCatalog) {
        ArrayList catalogViewList1 = new ArrayList();
        ArrayList<Map> mapList = new ArrayList<Map>();
        if (!CollectionUtils.isEmpty(catalogViewList)) {
            for (CatalogView catalogView : catalogViewList) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("value", catalogView.getId());
                map.put("label", catalogView.getTitle());
                map.put("type", catalogView.getType());
                map.put("status", "0");
                map.put("weight", catalogView.getWeight());
                if (!CollectionUtils.isEmpty((Collection)catalogView.getChildren()) && catalogView.getChildren().size() > 0) {
                    map.put("children", this.getCatalogViewList(catalogView.getChildren(), serverCatalog));
                } else if (serverCatalog != null) {
                    map.put("children", catalogViewList1);
                }
                mapList.add(map);
            }
            return mapList;
        }
        return new ArrayList<Map>();
    }

    @RequestMapping(value={"/updateCatalog"})
    public Object updateCatalog(@RequestParam(name="nodeArr[]") String[] nodeArr, @RequestParam(name="type") String type) {
        try {
            return this.catalogClient.updateCatalog(nodeArr, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getProxyUrl(String resourceId, String capableType) {
        int size = 0;
        Random random = new Random();
        size = random.nextInt(this.discoveryClient.getInstances("resource-proxy").size());
        String proxyUrl = ((ServiceInstance)this.discoveryClient.getInstances("resource-proxy").get(size)).getUri().toString();
        List dictList = new ArrayList();
        try {
            dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e");
        }
        ArrayList<String> urlList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(dictList)) {
            for (Dict dict : dictList) {
                urlList.add(dict.getValue());
            }
        }
        proxyUrl = Utils.urlMapping((String)proxyUrl, urlList);
        proxyUrl = proxyUrl.concat("/resp/").concat(resourceId).concat("/").concat(capableType);
        return proxyUrl;
    }

    @RequestMapping(value={"/findDefaultCatalog"})
    public Object findDefaultCatalog(@RequestParam(name="dicId") String dicId) {
        List catalogList = new ArrayList();
        Dict dict = this.dictClient.findDictByDicId(dicId);
        if (dict.getValue() != null) {
            catalogList = this.catalogClient.findCatalogIdsByIds(dict.getValue());
        }
        return catalogList;
    }

    @PostMapping(value={"/copyCatalogs"})
    public Object copyCatalogs(@RequestBody Map map) {
        return this.catalogClient.copyCatalogs(map);
    }

    @RequestMapping(value={"/saveCatalogAndTplRef"})
    public Object saveCatTplRef(@RequestParam(name="catalogId", required=false) String catalogId, @RequestParam(name="tplIds[]", required=false) String[] tplIds, @RequestParam(name="replace", required=false) boolean replace) {
        return this.catalogClient.saveCatTplRef(catalogId, tplIds, replace);
    }

    @RequestMapping(value={"/findTplsByCatalogId"})
    public List<Tpl> findTplsByCatalogId(@RequestParam(name="catalogId", required=false) String catalogId) {
        return this.catalogClient.findTplsByCatalogId(catalogId);
    }

    @RequestMapping(value={"/findCatalogsByTplId"})
    public List<Catalog> findCatalogsByTplId(@RequestParam(name="tplId", required=false) String tplId) {
        return this.catalogClient.findCatalogsByTplId(tplId);
    }
}

