/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.web;

import cn.gtmap.gtcc.tddc.domain.resource.metadata.Dict;
import cn.gtmap.gtcc.tddc.service.clients.resource.DictClient;
import cn.gtmap.gtcc.tddc.utils.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@CrossOrigin
@RequestMapping(value={"/dc"})
public class ResourceController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static List<String> instancesNeedUri = Lists.newArrayList((Object[])new String[]{"storage-app", "gis-analysis"});
    final DiscoveryClient discoveryClient;
    @Autowired
    private DictClient dictClient;

    @Autowired
    public ResourceController(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @ModelAttribute
    public void uriAttribute(Model model) {
        try {
            List dicts = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("sysTitle").getId());
            if (!CollectionUtils.isEmpty((Collection)dicts)) {
                for (Dict dict : dicts) {
                    model.addAttribute(dict.getDictKey(), (Object)dict.getValue());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u786e\u8ba4sysTitle\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e", (Throwable)e);
        }
        for (String client : instancesNeedUri) {
            List instances = this.discoveryClient.getInstances(client);
            if (instances.isEmpty()) continue;
            String mappingUrl = ((ServiceInstance)instances.get(0)).getUri().toString();
            List dictList = new ArrayList();
            try {
                dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
            }
            catch (Exception e) {
                this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e");
            }
            ArrayList<String> urlList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(dictList)) {
                for (Dict dict : dictList) {
                    urlList.add(dict.getValue());
                }
            }
            mappingUrl = Utils.urlMapping((String)mappingUrl, urlList);
            model.addAttribute(client.replaceAll("-", ""), (Object)mappingUrl);
        }
    }

    @RequestMapping(value={"/index", "/"})
    public String index() {
        return "redirect:/dc/res";
    }

    @RequestMapping(value={"/res"})
    public String res() {
        return "res";
    }

    @RequestMapping(value={"/map/{tpl}"})
    public String map(@PathVariable String tpl) {
        return "map/".concat(tpl);
    }

    @RequestMapping(value={"/display"})
    public String display() {
        return "display";
    }

    @RequestMapping(value={"/search"})
    public String search() {
        return "search";
    }

    @RequestMapping(value={"/develop"})
    public String develop() {
        return "develop";
    }

    @RequestMapping(value={"/builder"})
    public String builder(HttpServletResponse response) {
        response.setHeader("X-Frame-Options", "SAMEORIGIN");
        return "builder";
    }
}

