/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.service.impl;

import cn.gtmap.gtcc.gis.resource.ui.dao.impl.JsydRepository;
import cn.gtmap.gtcc.gis.resource.ui.service.JsydDataService;
import cn.gtmap.gtcc.tddc.domain.gis.esm.Feature;
import cn.gtmap.gtcc.tddc.domain.resource.heatdata.JsydBpStatModel;
import cn.gtmap.gtcc.tddc.service.clients.gis.data.search.EsAttributeQueryClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JsydDataServiceImpl
implements JsydDataService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JsydRepository jsydRepo;
    private final EsAttributeQueryClient esAttrQueryClient;

    @Autowired
    public JsydDataServiceImpl(JsydRepository jsydRepo, EsAttributeQueryClient esAttrQueryClient) {
        this.jsydRepo = jsydRepo;
        this.esAttrQueryClient = esAttrQueryClient;
    }

    public List<JsydBpStatModel> statByXzq() {
        try {
            List statModels = this.jsydRepo.statByXzqdm();
            for (JsydBpStatModel model : statModels) {
                String xzqdm = model.getXzqdm();
                List fs = this.esAttrQueryClient.inQuery("XZQDM", new String[]{xzqdm}, "xzq_point");
                if (fs == null || fs.size() <= 0) continue;
                Feature f = (Feature)fs.get(0);
                List coords = f.getGeometry().getCoordinates();
                model.setX(((Double)coords.get(0)).doubleValue());
                model.setY(((Double)coords.get(1)).doubleValue());
            }
            return statModels;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

