/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.service.impl;

import cn.gtmap.gtcc.gis.resource.ui.dao.impl.GyydRepository;
import cn.gtmap.gtcc.gis.resource.ui.service.GyydDataService;
import cn.gtmap.gtcc.tddc.domain.gis.esm.Feature;
import cn.gtmap.gtcc.tddc.domain.resource.heatdata.GyydStatModel;
import cn.gtmap.gtcc.tddc.service.clients.gis.data.search.EsAttributeQueryClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GyydDataServiceImpl
implements GyydDataService {
    private final GyydRepository gyydRepo;
    private final EsAttributeQueryClient esAttrQueryClient;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public GyydDataServiceImpl(GyydRepository gyydRepo, EsAttributeQueryClient esAttrQueryClient) {
        this.gyydRepo = gyydRepo;
        this.esAttrQueryClient = esAttrQueryClient;
    }

    public List<GyydStatModel> statByXzq() {
        try {
            List statModels = this.gyydRepo.statByXzqdm();
            for (GyydStatModel model : statModels) {
                String xzqdm = model.getXzqdm();
                List features = this.esAttrQueryClient.inQuery("XZQDM", new String[]{xzqdm}, "xzq_point");
                if (features == null || features.size() <= 0) continue;
                Feature f = (Feature)features.get(0);
                List coords = f.getGeometry().getCoordinates();
                model.setX(((Double)coords.get(0)).doubleValue());
                model.setY(((Double)coords.get(1)).doubleValue());
            }
            return statModels;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

