/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtcc.gis.resource.ui.config.interceptor;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtcc.tddc.domain.resource.metadata.Dict;
import cn.gtmap.gtcc.tddc.service.clients.resource.DictClient;
import cn.gtmap.gtcc.tddc.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class MapInterceptor
implements HandlerInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    UserManagerClient userManagerClient;
    @Autowired
    DiscoveryClient discoveryClient;
    @Autowired
    DictClient dictClient;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        UserDto userDto = this.userManagerClient.getUserDetailByUsername(auth.getName());
        String tagValue = "1";
        String tagMap = request.getParameter("map");
        if (tagValue.equals(tagMap)) {
            return true;
        }
        for (RoleDto roleDto : userDto.getRoleRecordList()) {
            if (this.isDisplayCenterRole(roleDto)) {
                String mapUrl = "";
                try {
                    List list = this.discoveryClient.getInstances("data-map");
                    if (list.size() > 0) {
                        mapUrl = ((ServiceInstance)list.get(0)).getUri().toString() + "/map/index?loginName=" + userDto.getUsername() + "&sr=4490";
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6map\u5730\u5740\u5f02\u5e38" + e);
                }
                List dictList = new ArrayList();
                try {
                    dictList = this.dictClient.findDefaultDicts(this.dictClient.findValueByKey("serverMapping").getId());
                }
                catch (Exception e) {
                    this.logger.error("\u8bf7\u786e\u8ba4serverMapping\u5b57\u5178\u9879\u662f\u5426\u914d\u7f6e\u6b63\u786e");
                }
                ArrayList<String> urlList = new ArrayList<String>();
                if (!CollectionUtils.isEmpty(dictList)) {
                    for (Dict dict : dictList) {
                        urlList.add(dict.getValue());
                    }
                }
                mapUrl = Utils.urlMapping((String)mapUrl, urlList);
                response.sendRedirect(mapUrl);
                return false;
            }
            if (!this.isQuXianRole(roleDto)) continue;
            response.sendRedirect(request.getContextPath() + "/dc/res/#/resHome");
            return false;
        }
        this.logger.info("=====preHandle\u88ab\u8c03\u7528============================");
        return true;
    }

    private boolean isDisplayCenterRole(RoleDto roleDto) {
        boolean isTrue = false;
        String roleName = "displayCenter";
        if (roleName.equals(roleDto.getName())) {
            isTrue = true;
        }
        return isTrue;
    }

    private boolean isQuXianRole(RoleDto roleDto) {
        boolean isTrue = false;
        String roleName = "quxianji";
        if (roleName.equals(roleDto.getName())) {
            isTrue = true;
        }
        return isTrue;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.logger.info("postHandle\u88ab\u8c03\u7528");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.logger.info("afterCompletion\u88ab\u8c03\u7528");
    }
}

