/*
 * Decompiled with CFR 0.152.
 */
package com.finstone.house.iface.ws.client;

import com.caucho.hessian.io.HessianOutput;
import com.finstone.house.iface.ws.client.FrameInvokeServiceClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class hessian {
    private static String DEFAULT_CHARSET = "UTF-8";
    private static int BUFFER_SIZE = 2048;
    private static FrameInvokeServiceClient client = null;
    private static final String KEY_MD5 = "MD5";
    private static final String[] strDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private static String byteToArrayString(byte bByte) {
        int iRet = bByte;
        if (iRet < 0) {
            iRet += 256;
        }
        int iD1 = iRet / 16;
        int iD2 = iRet % 16;
        return String.valueOf(strDigits[iD1]) + strDigits[iD2];
    }

    private static String byteToString(byte[] bByte) {
        StringBuffer sBuffer = new StringBuffer();
        int i = 0;
        while (i < bByte.length) {
            sBuffer.append(hessian.byteToArrayString(bByte[i]));
            ++i;
        }
        return sBuffer.toString();
    }

    public static String GetMD5Code(String strObj) throws Exception {
        MessageDigest md = MessageDigest.getInstance(KEY_MD5);
        return hessian.byteToString(md.digest(strObj.getBytes(DEFAULT_CHARSET)));
    }

    public static byte[] compress(byte[] bytes) {
        byte[] byArray;
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(new GZIPOutputStream(baos));
            dos.write(bytes);
            dos.close();
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new ZipException(e);
            }
            catch (Throwable throwable) {
                hessian.closeQuietly(dos);
                hessian.closeQuietly(baos);
                throw throwable;
            }
        }
        hessian.closeQuietly(dos);
        hessian.closeQuietly(baos);
        return byArray;
    }

    public static String compress1(String source) {
        byte[] sourcebytes = null;
        try {
            sourcebytes = source.getBytes(DEFAULT_CHARSET);
            return String.valueOf(hessian.md5(source)) + hessian.compressToString(sourcebytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static String compress(String source) {
        byte[] sourcebytes = null;
        try {
            sourcebytes = source.getBytes(DEFAULT_CHARSET);
            return String.valueOf(hessian.GetMD5Code(source)) + hessian.compressToString(sourcebytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static String compress(InputStream is) {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[BUFFER_SIZE];
            int offset = -1;
            while ((offset = is.read(buffer)) != -1) {
                baos.write(buffer, 0, offset);
            }
            return hessian.compressToString(baos.toByteArray());
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static String compressToString(byte[] bytes) {
        byte[] sourcebytes = hessian.compress(bytes);
        String b64str = new BASE64Encoder().encode(sourcebytes);
        b64str = b64str.replaceAll("\r\n", "");
        b64str = b64str.replaceAll("\n", "");
        b64str = b64str.replaceAll(" ", "");
        return b64str;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompress(byte[] bytes) {
        byte[] byArray;
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream zin = null;
        try {
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(bytes);
            zin = new GZIPInputStream(in);
            byte[] buffer = new byte[BUFFER_SIZE];
            int offset = -1;
            while (true) {
                if ((offset = zin.read(buffer)) == -1) {
                    byArray = out.toByteArray();
                    break;
                }
                out.write(buffer, 0, offset);
            }
        }
        catch (IOException e) {
            try {
                throw new ZipException(e);
                catch (Exception e2) {
                    throw new ZipException(e2);
                }
            }
            catch (Throwable throwable) {
                hessian.closeQuietly(out);
                hessian.closeQuietly(zin);
                hessian.closeQuietly(in);
                throw throwable;
            }
        }
        hessian.closeQuietly(out);
        hessian.closeQuietly(zin);
        hessian.closeQuietly(in);
        return byArray;
    }

    public static byte[] decompressFromString(String source) {
        byte[] sourcebytes = null;
        try {
            source = source.replaceAll("\r\n", "");
            source = source.replaceAll("\n", "");
            source = source.replaceAll(" ", "");
            sourcebytes = new BASE64Decoder().decodeBuffer(source);
            return hessian.decompress(sourcebytes);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static String bytes2HexString(byte[] b) {
        String ret = "";
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            if (i > 0 && i % 16 == 0) {
                ret = String.valueOf(ret) + "\r\n";
            }
            ret = String.valueOf(ret) + " ";
            ret = String.valueOf(ret) + hex.toUpperCase();
            ++i;
        }
        ret = String.valueOf(ret) + "\r\n";
        return ret;
    }

    public static String decompress1(String source) {
        String source_md5 = source.substring(0, 24);
        String source_bw = source.substring(24);
        String bw = null;
        byte[] sourcebytes = hessian.decompressFromString(source_bw);
        try {
            bw = new String(sourcebytes, DEFAULT_CHARSET);
            if (!hessian.md5(bw).equals(source_md5)) {
                throw new ZipException("The source message is corrupted");
            }
            return bw;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static String decompress(String source) {
        String source_md5 = source.substring(0, 32);
        String source_bw = source.substring(32);
        String bw = null;
        byte[] sourcebytes = hessian.decompressFromString(source_bw);
        try {
            bw = new String(sourcebytes, DEFAULT_CHARSET);
            String test = hessian.GetMD5Code(bw);
            if (!test.equals(source_md5)) {
                throw new ZipException("The source message is corrupted");
            }
            return bw;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static String decompressA(String source) {
        byte[] sourcebytes = hessian.decompressFromString(source);
        try {
            return new String(sourcebytes, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception e) {
                os = null;
            }
        }
    }

    public static void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                is = null;
            }
        }
    }

    public static String readXmlStringFromFile() {
        try {
            BufferedReader in = new BufferedReader(new FileReader("c://1.txt"));
            String s = null;
            StringBuffer sb = new StringBuffer();
            while ((s = in.readLine()) != null) {
                sb.append(s).append("\r\n");
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String md5(String strEncrypt) {
        byte[] BYTES_KEY = new byte[]{-99, 118, 97, -105, -51, -17, 81, 14};
        try {
            byte[] b = strEncrypt.getBytes("UTF8");
            SecretKeySpec key = new SecretKeySpec(BYTES_KEY, "DES");
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding", SystemUtilsEx.getJCEName());
            cipher.init(1, key);
            b = cipher.doFinal(b);
            BASE64Encoder encoder = new BASE64Encoder();
            strEncrypt = encoder.encode(b);
            MessageDigest md = MessageDigest.getInstance(KEY_MD5);
            strEncrypt = strEncrypt.replaceAll("\r\n", "");
            strEncrypt = strEncrypt.replaceAll("\n", "");
            md.update(strEncrypt.getBytes("UTF8"));
            strEncrypt = encoder.encode(md.digest());
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
        return strEncrypt;
    }

    public static String getSignstring(String sHessian) {
        String sSign = sHessian.substring(0, 24);
        return sSign;
    }

    public static String getCdata(String sHessian) {
        String sCdata = sHessian.substring(24);
        return sCdata;
    }

    public static boolean isDefaced(String sHessian) {
        String sBw = hessian.getRequestData(sHessian);
        String source_md5 = sBw.substring(0, 24);
        String source_bw = sBw.substring(24);
        String bw = null;
        byte[] sourcebytes = hessian.decompressFromString(source_bw);
        try {
            bw = new String(sourcebytes, DEFAULT_CHARSET);
            return hessian.md5(bw).equals(source_md5);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static String getSignCdata(String sSrc) {
        String sSign = hessian.compress(sSrc);
        return sSign;
    }

    public static String getHessianData(String sSrc) {
        String sHessianData;
        String sSignCdata = hessian.getSignCdata(sSrc);
        ByteArrayOutputStream os = null;
        os = new ByteArrayOutputStream();
        HessianOutput out = new HessianOutput((OutputStream)os);
        out.setVersion(2);
        try {
            out.startCall("invoke", 6);
            out.writeString(sSignCdata);
            out.completeCall();
            out.flush();
            sHessianData = ((Object)os).toString();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        byte[] sourcebytes = null;
        try {
            sourcebytes = sHessianData.getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new ZipException(e);
        }
        return sHessianData;
    }

    public static String sendHessian(String sSignData) {
        String retxml = client.invoke(sSignData, "UTF-8");
        return retxml;
    }

    public static void setHessianURL(String sUrl) {
        client = new FrameInvokeServiceClient();
        client.setUrl(sUrl);
    }

    public static String getData(String sSignData) {
        String retxml = hessian.compress(sSignData);
        return retxml;
    }

    public static String getRequestData(String sHessianData) {
        String retdata = sHessianData.substring(15, sHessianData.length() - 1);
        return retdata;
    }

    public static String readXmlStringFromFile(String fPath) {
        try {
            String src = FileUtils.readFileToString((File)new File(fPath), (String)"UTF8");
            src = src.replaceAll("\r\n", "");
            src = src.replaceAll("\n", "");
            return src;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String src = hessian.readXmlStringFromFile("d://003.txt");
        System.out.println(src);
        String dest = hessian.GetMD5Code(src);
        System.out.println("[decompress]:" + dest);
        System.exit(0);
    }

    public static String getDEFAULT_CHARSET() {
        return DEFAULT_CHARSET;
    }

    public static void setDEFAULT_CHARSET(String default_charset) {
        DEFAULT_CHARSET = default_charset;
    }

    public static class SystemUtilsEx {
        private static Boolean isInitJCE = false;

        public static boolean isIBM() {
            return SystemUtils.JAVA_VM_VENDOR.contains("IBM");
        }

        public static String getJCEName() {
            return SystemUtilsEx.isIBM() ? "IBMJCE" : "SunJCE";
        }

        public static void initJCE() {
            if (!isInitJCE.booleanValue()) {
                Class<?> providerClz = null;
                try {
                    providerClz = SystemUtilsEx.isIBM() ? Class.forName("com.ibm.crypto.provider.IBMJCE") : Class.forName("com.sun.crypto.provider.SunJCE");
                }
                catch (ClassNotFoundException e) {
                    throw new ZipException("System's JDK:" + SystemUtils.JAVA_VM_VENDOR + ",can not find JCE class");
                }
                Provider provider = null;
                try {
                    provider = (Provider)providerClz.newInstance();
                }
                catch (Exception e) {
                    throw new ZipException("Creat Object:" + providerClz.getName() + "error:" + e.getMessage());
                }
                Security.addProvider(provider);
                isInitJCE = true;
            }
        }
    }

    public static class ZipException
    extends RuntimeException {
        private static final long serialVersionUID = -3193193334253315702L;

        public ZipException() {
        }

        public ZipException(String message) {
            super(message);
        }

        public ZipException(String message, Throwable cause) {
            super(message, cause);
        }

        public ZipException(Throwable cause) {
            super(cause);
        }
    }
}

