/*
 * Decompiled with CFR 0.152.
 */
package com.finstone.house.app.util;

import com.finstone.house.app.util.ZipUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ZipUtilsEx {
    private String DEFAULT_CHARSET = "GB18030";
    private int BUFFER_SIZE = 2048;

    public byte[] compress(byte[] bytes) {
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(new GZIPOutputStream(baos));
            dos.write(bytes);
            dos.close();
            byte[] byArray = baos.toByteArray();
            this.closeQuietly(dos);
            this.closeQuietly(baos);
            return byArray;
        }
        catch (Exception e) {
            try {
                throw new ZipException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(dos);
                this.closeQuietly(baos);
                throw throwable;
            }
        }
    }

    public String compress(String source) {
        byte[] sourcebytes = null;
        try {
            sourcebytes = source.getBytes(this.DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZipException((Throwable)e);
        }
        return this.compressToString(sourcebytes);
    }

    public String compress(String source, String encoding) {
        byte[] sourcebytes = null;
        try {
            sourcebytes = source.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZipException((Throwable)e);
        }
        return this.compressToString(sourcebytes);
    }

    public String compress(File file) {
        byte[] sourcebytes = null;
        try {
            sourcebytes = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new ZipException((Throwable)e);
        }
        return this.compressToString(sourcebytes);
    }

    public String compress(File file, String encoding) {
        byte[] sourcebytes = null;
        String sourcestring = null;
        try {
            sourcestring = FileUtils.readFileToString((File)file, (String)encoding);
            sourcebytes = sourcestring.getBytes(encoding);
        }
        catch (IOException e) {
            throw new ZipException((Throwable)e);
        }
        return this.compressToString(sourcebytes);
    }

    public String compress(InputStream is) {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[this.BUFFER_SIZE];
            int offset = -1;
            while ((offset = is.read(buffer)) != -1) {
                baos.write(buffer, 0, offset);
            }
            return this.compressToString(baos.toByteArray());
        }
        catch (Exception e) {
            throw new ZipException((Throwable)e);
        }
    }

    public String compressToString(byte[] bytes) {
        byte[] sourcebytes = this.compress(bytes);
        String b64str = new BASE64Encoder().encode(sourcebytes);
        b64str = b64str.replaceAll("\r\n", "");
        b64str = b64str.replaceAll("\n", "");
        return b64str;
    }

    public byte[] compressToByteArray(File file) {
        byte[] sourcebytes = null;
        try {
            sourcebytes = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new ZipException((Throwable)e);
        }
        return this.compress(sourcebytes);
    }

    public byte[] decompress(byte[] bytes) {
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream zin = null;
        try {
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(bytes);
            zin = new GZIPInputStream(in);
            byte[] buffer = new byte[this.BUFFER_SIZE];
            int offset = -1;
            while ((offset = zin.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            byte[] byArray = out.toByteArray();
            this.closeQuietly(out);
            this.closeQuietly(zin);
            this.closeQuietly(in);
            return byArray;
        }
        catch (Exception e) {
            try {
                throw new ZipException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(out);
                this.closeQuietly(zin);
                this.closeQuietly(in);
                throw throwable;
            }
        }
    }

    public byte[] decompressFromString(String source) {
        byte[] sourcebytes = null;
        try {
            source = source.replaceAll("\r\n", "");
            source = source.replaceAll("\n", "");
            source = source.replaceAll(" ", "");
            sourcebytes = new BASE64Decoder().decodeBuffer(source);
            return this.decompress(sourcebytes);
        }
        catch (Exception e) {
            throw new ZipException((Throwable)e);
        }
    }

    public String decompress(String source) {
        byte[] sourcebytes = this.decompressFromString(source);
        try {
            return new String(sourcebytes, this.DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new ZipException((Throwable)e);
        }
    }

    public String decompress(String source, String encoding) {
        byte[] sourcebytes = this.decompressFromString(source);
        try {
            return new String(sourcebytes, encoding);
        }
        catch (Exception e) {
            throw new ZipException((Throwable)e);
        }
    }

    public void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception e) {
                os = null;
            }
        }
    }

    public void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                is = null;
            }
        }
    }

    protected String readXmlStringFromFile() {
        try {
            BufferedReader in = new BufferedReader(new FileReader("c://1.txt"));
            String s = null;
            StringBuffer sb = new StringBuffer();
            while ((s = in.readLine()) != null) {
                sb.append(s).append("\r\n");
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDEFAULT_CHARSET() {
        return this.DEFAULT_CHARSET;
    }

    public void setDEFAULT_CHARSET(String default_charset) {
        this.DEFAULT_CHARSET = default_charset;
    }

    public static void main(String[] args) throws Exception {
        String src = "H4sIAAAAAAAAAF2QQW7DIBBFr4J8gHrAOLalyURKF1GO4QbaotaQglWlOVX33WeZM3Uwlip19/n/8WcAd5fpXXzamFzw20o+QCWsPwXj/Mu2OuxlDw1UO8IYwkwCX+1oSAhM1hsb6QAS61WzG+2Jq+jxuJcAWK9HDsbz2RnKcFFszXH0iQdZAt0znsM/bwVmN1lSILVUjYRBaWgLtQQMuWQ/fPiHAAwbzfPXUGBd1sanYL7yLfMWLxP93O7fWBddzPR8pUbBpldy6DvQCtquaxcmR1y0NPDL8m/8AvLw6s48AQAA";
        ZipUtils.setDEFAULT_CHARSET("GB18030");
        String dest = ZipUtils.decompress(src);
        System.out.println("[decompress]:" + dest);
    }

    public class ZipException
    extends RuntimeException {
        private final long serialVersionUID = -3193193334253315702L;

        public ZipException() {
            this.serialVersionUID = -3193193334253315702L;
        }

        public ZipException(String message) {
            super(message);
            this.serialVersionUID = -3193193334253315702L;
        }

        public ZipException(String message, Throwable cause) {
            super(message, cause);
            this.serialVersionUID = -3193193334253315702L;
        }

        public ZipException(Throwable cause) {
            super(cause);
            this.serialVersionUID = -3193193334253315702L;
        }
    }
}

