/*
 * Decompiled with CFR 0.152.
 */
package com.finstone.house.app.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.sql.rowset.serial.SerialClob;
import oracle.sql.CLOB;
import org.apache.commons.io.FileUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ZipUtils {
    private static String DEFAULT_CHARSET = "UTF-8";
    private static int BUFFER_SIZE = 2048;

    public static byte[] compress(byte[] bytes) {
        byte[] byArray;
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(new GZIPOutputStream(baos));
            dos.write(bytes);
            dos.close();
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new ZipException(e);
            }
            catch (Throwable throwable) {
                ZipUtils.closeQuietly(dos);
                ZipUtils.closeQuietly(baos);
                throw throwable;
            }
        }
        ZipUtils.closeQuietly(dos);
        ZipUtils.closeQuietly(baos);
        return byArray;
    }

    public static String CLOBToString(CLOB clob) {
        if (clob == null) {
            return null;
        }
        try {
            Reader inStreamDoc = clob.getCharacterStream();
            char[] tempDoc = new char[(int)clob.length()];
            inStreamDoc.read(tempDoc);
            inStreamDoc.close();
            return new String(tempDoc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException es) {
            es.printStackTrace();
        }
        return null;
    }

    private Clob getClob(String clobData) throws Exception {
        SerialClob c = new SerialClob(clobData.toCharArray());
        return c;
    }

    private static CLOB getCLOB(String clobData) throws Exception {
        CLOB tempClob = null;
        Class.forName("oracle.jdbc.OracleDriver");
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@172.16.1.240:1521:orcl", "hfmcap_wx_201303", "123");
        tempClob = CLOB.createTemporary((Connection)conn, (boolean)false, (int)10);
        tempClob.open(1);
        tempClob.truncate(0L);
        Writer tempClobWriter = tempClob.getCharacterOutputStream();
        tempClobWriter.write(clobData);
        tempClobWriter.flush();
        tempClobWriter.close();
        tempClob.close();
        return tempClob;
    }

    public static String compress(String source) {
        byte[] sourcebytes = null;
        try {
            sourcebytes = source.getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZipException(e);
        }
        return ZipUtils.compressToString(sourcebytes);
    }

    public static String compress(File file) {
        byte[] sourcebytes = null;
        try {
            sourcebytes = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        return ZipUtils.compressToString(sourcebytes);
    }

    public static String compress(File file, String encoding) {
        byte[] sourcebytes = null;
        String sourcestring = null;
        try {
            sourcestring = FileUtils.readFileToString((File)file, (String)encoding);
            sourcebytes = sourcestring.getBytes(encoding);
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        return ZipUtils.compressToString(sourcebytes);
    }

    public static String compress(InputStream is) {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[BUFFER_SIZE];
            int offset = -1;
            while ((offset = is.read(buffer)) != -1) {
                baos.write(buffer, 0, offset);
            }
            return ZipUtils.compressToString(baos.toByteArray());
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static String compressToString(byte[] bytes) {
        byte[] sourcebytes = ZipUtils.compress(bytes);
        String b64str = new BASE64Encoder().encode(sourcebytes);
        b64str = b64str.replaceAll("\r\n", "");
        b64str = b64str.replaceAll("\n", "");
        return b64str;
    }

    public static byte[] compressToByteArray(File file) {
        byte[] sourcebytes = null;
        try {
            sourcebytes = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        return ZipUtils.compress(sourcebytes);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompress(byte[] bytes) {
        byte[] byArray;
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream zin = null;
        try {
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(bytes);
            zin = new GZIPInputStream(in);
            byte[] buffer = new byte[BUFFER_SIZE];
            int offset = -1;
            while (true) {
                if ((offset = zin.read(buffer)) == -1) {
                    byArray = out.toByteArray();
                    break;
                }
                out.write(buffer, 0, offset);
            }
        }
        catch (IOException e) {
            try {
                throw new ZipException(e);
                catch (Exception e2) {
                    throw new ZipException(e2);
                }
            }
            catch (Throwable throwable) {
                ZipUtils.closeQuietly(out);
                ZipUtils.closeQuietly(zin);
                ZipUtils.closeQuietly(in);
                throw throwable;
            }
        }
        ZipUtils.closeQuietly(out);
        ZipUtils.closeQuietly(zin);
        ZipUtils.closeQuietly(in);
        return byArray;
    }

    public static byte[] decompressFromString(String source) {
        byte[] sourcebytes = null;
        try {
            source = source.replaceAll("\r\n", "");
            source = source.replaceAll("\n", "");
            source = source.replaceAll(" ", "");
            sourcebytes = new BASE64Decoder().decodeBuffer(source);
            return ZipUtils.decompress(sourcebytes);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static String bytes2HexString(byte[] b) {
        String ret = "";
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            if (i > 0 && i % 16 == 0) {
                ret = String.valueOf(ret) + "\r\n";
            }
            ret = String.valueOf(ret) + " ";
            ret = String.valueOf(ret) + hex.toUpperCase();
            ++i;
        }
        ret = String.valueOf(ret) + "\r\n";
        return ret;
    }

    public static String decompress(String source) {
        byte[] sourcebytes = ZipUtils.decompressFromString(source);
        try {
            return new String(sourcebytes, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public static void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception e) {
                os = null;
            }
        }
    }

    public static void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                is = null;
            }
        }
    }

    public static String readXmlStringFromFile() {
        try {
            BufferedReader in = new BufferedReader(new FileReader("c://1.txt"));
            String s = null;
            StringBuffer sb = new StringBuffer();
            while ((s = in.readLine()) != null) {
                sb.append(s).append("\r\n");
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String src = ZipUtils.readXmlStringFromFile();
        DEFAULT_CHARSET = "UTF-8";
        String dest = ZipUtils.decompress(src);
        System.out.println("[decompress]:" + dest);
    }

    public static String getDEFAULT_CHARSET() {
        return DEFAULT_CHARSET;
    }

    public static void setDEFAULT_CHARSET(String default_charset) {
        DEFAULT_CHARSET = default_charset;
    }

    public static class ZipException
    extends RuntimeException {
        private static final long serialVersionUID = -3193193334253315702L;

        public ZipException() {
        }

        public ZipException(String message) {
            super(message);
        }

        public ZipException(String message, Throwable cause) {
            super(message, cause);
        }

        public ZipException(Throwable cause) {
            super(cause);
        }
    }
}

