/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.secondaryMarket.common.utils.db;

import cn.gtmap.secondaryMarket.common.utils.db.Page;
import java.io.Serializable;

public class PageRequest
implements Serializable {
    private int pageNum;
    private int pageSize;
    private int startRow;
    private int endRow;
    private long total;
    private int pages;

    public PageRequest() {
    }

    public PageRequest(int pageNum, int pageSize) {
        this(pageNum, pageSize, 1);
    }

    public PageRequest(int startRow, int endRow, int pageNum, int pageSize) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = 1L;
    }

    public PageRequest(int pageNum, int pageSize, int total) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.startRow = pageNum > 0 ? (pageNum - 1) * pageSize : 0;
        this.endRow = pageNum * pageSize;
    }

    public Page getPage() {
        return new Page(this.pageNum, this.pageSize, this.total);
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }
}

