/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.secondaryMarket.common.utils.db;

import cn.gtmap.secondaryMarket.common.utils.ReflectUtil;
import cn.gtmap.secondaryMarket.common.utils.db.Page;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class OraclePageHelper
implements Interceptor {
    private static Logger Log = LoggerFactory.getLogger(OraclePageHelper.class);
    private static String dialect = "oracle";

    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
            BoundSql boundSql = statementHandler.getBoundSql();
            System.out.println(boundSql.getSql());
            PageRequest page = this.getPageFromBoundSql(boundSql);
            if (page != null) {
                String sql = boundSql.getSql();
                if (page.getTotal() > 0L) {
                    Connection connection = (Connection)invocation.getArgs()[0];
                    MappedStatement mappedStatement = (MappedStatement)ReflectUtil.getFieldValue(ReflectUtil.getFieldValue(statementHandler, "delegate"), "mappedStatement");
                    page.setTotal(this.getTotalCount(connection, mappedStatement, boundSql, sql));
                    int pages = (int)((page.getTotal() + (long)page.getPageSize() - 1L) / (long)page.getPageSize());
                    page.setPages(pages);
                }
                String pageSql = this.getPageSql(sql, page);
                ReflectUtil.setFieldValue(boundSql, "sql", pageSql);
                System.out.println(pageSql);
            }
            return invocation.proceed();
        }
        if (invocation.getTarget() instanceof ResultSetHandler) {
            ResultSetHandler resultSetHandler;
            BoundSql boundSql;
            PageRequest pageRequest;
            Object result = invocation.proceed();
            if (result instanceof List && (pageRequest = this.getPageFromBoundSql(boundSql = (BoundSql)ReflectUtil.getFieldValue(resultSetHandler = (ResultSetHandler)invocation.getTarget(), "boundSql"))) != null) {
                Page page = pageRequest.getPage();
                page.addAll((List)result);
                return page;
            }
            return result;
        }
        return null;
    }

    private PageRequest getPageFromBoundSql(BoundSql boundSql) {
        Object obj = boundSql.getParameterObject();
        if (obj instanceof PageRequest) {
            return (PageRequest)obj;
        }
        if (obj instanceof Map) {
            for (Object param : ((Map)obj).values()) {
                if (!(param instanceof PageRequest)) continue;
                return (PageRequest)param;
            }
        }
        return null;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler || target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTotalCount(Connection connection, MappedStatement mappedStatement, BoundSql boundSql, String sql) {
        String countSql = this.getCountSql(sql);
        PreparedStatement countStmt = null;
        ResultSet rs = null;
        try {
            countStmt = connection.prepareStatement(countSql);
            BoundSql countBS = this.copyFromBoundSql(mappedStatement, boundSql, countSql);
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), countBS);
            parameterHandler.setParameters(countStmt);
            rs = countStmt.executeQuery();
            long totalCount = 0L;
            if (rs.next()) {
                totalCount = rs.getLong(1);
            }
            long l = totalCount;
            return l;
        }
        catch (SQLException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
            try {
                countStmt.close();
            }
            catch (SQLException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        return 0L;
    }

    private String getPageSql(String sql, PageRequest page) {
        StringBuilder pageSql = new StringBuilder(200);
        if ("postgresql".equals(dialect)) {
            pageSql.append(sql);
            pageSql.append(" limit " + page.getPageSize() + " offset " + page.getStartRow());
        } else if ("mysql".equals(dialect)) {
            pageSql.append(sql);
            pageSql.append(" limit " + page.getStartRow() + "," + page.getPageSize());
        } else if ("hsqldb".equals(dialect)) {
            pageSql.append(sql);
            pageSql.append(" LIMIT " + page.getPageSize() + " OFFSET " + page.getStartRow());
        } else if ("oracle".equals(dialect)) {
            pageSql.append("select * from ( select temp.*, rownum row_id from ( ");
            pageSql.append(sql);
            pageSql.append(" ) temp where rownum <= ").append(page.getEndRow());
            pageSql.append(") where row_id > ").append(page.getStartRow());
        }
        return pageSql.toString();
    }

    public String getCountSql(String sql) {
        StringBuffer sb = new StringBuffer("select count(1) from ");
        if ((sql = sql.toLowerCase()).lastIndexOf("order by") > sql.lastIndexOf(")")) {
            sb.append(sql.substring(sql.indexOf("from") + 4, sql.lastIndexOf("order by")));
        } else {
            sb.append(sql.substring(sql.indexOf("from") + 4));
        }
        return sb.toString();
    }

    public static void setDialect(String dialect) {
        OraclePageHelper.dialect = dialect;
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private BoundSql copyFromBoundSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }
}

