/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.secondaryMarket.common.utils.db;

import cn.gtmap.secondaryMarket.common.utils.db.PageDefault;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Configuration
public class DataPageableHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return PageRequest.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Integer index;
        Integer size;
        Integer count = 0;
        PageDefault def = (PageDefault)parameter.getParameterAnnotation(PageDefault.class);
        if (def != null) {
            size = this.getParam(webRequest, "size", def.prefix(), def.value());
            index = this.getParam(webRequest, "index", def.prefix(), def.index());
            count = 1;
        } else {
            size = this.getParam(webRequest, "size", null, null);
            index = this.getParam(webRequest, "index", null, null);
            count = this.getParam(webRequest, "count", null, null);
        }
        if (size == null || size == 0) {
            size = 20;
        }
        if (index == null || index < 1) {
            index = 20;
        }
        if (count == null) {
            count = 1;
        }
        return new PageRequest(index, size, count);
    }

    private Integer getParam(NativeWebRequest webRequest, String name, String prefix, Integer def) {
        String s = webRequest.getParameter(StringUtils.isEmpty((CharSequence)prefix) ? name : prefix + "_" + name);
        return StringUtils.isNotEmpty((CharSequence)s) ? Integer.valueOf(s) : def;
    }
}

