/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ruleengine.util;

import cn.gtmap.ruleengine.enums.RuleEnum;
import cn.gtmap.ruleengine.event.EventName;
import cn.gtmap.ruleengine.model.RuleVo;
import cn.gtmap.ruleengine.operator.OperatorName;
import cn.gtmap.ruleengine.service.RuleEngineService;
import cn.gtmap.ruleengine.util.ClassUtil;
import cn.gtmap.ruleengine.util.SpringUtil;
import com.ql.util.express.DefaultContext;
import com.ql.util.express.DynamicParamsUtil;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.Operator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RuleExecutor {
    private static final Logger log = LoggerFactory.getLogger(RuleExecutor.class);
    private static final ExpressRunner RUNNER = new ExpressRunner();

    private RuleExecutor() {
    }

    private static void addLogic() throws Exception {
        RUNNER.addOperatorWithAlias("\u5982\u679c", "if", null);
        RUNNER.addOperatorWithAlias("\u5219", "then", null);
        RUNNER.addOperatorWithAlias("\u5426\u5219", "else", null);
        RUNNER.addOperatorWithAlias("\u5e76\u4e14", "and", null);
        RUNNER.addOperatorWithAlias("\u6216\u8005", "or", null);
        RUNNER.addOperatorWithAlias("\u8fd4\u56de", "return", null);
    }

    private static void addOperator(String operatorPackage) throws Exception {
        List<Class<?>> clsList = ClassUtil.getClasses(operatorPackage);
        if (!CollectionUtils.isEmpty(clsList)) {
            for (Class<?> cls : clsList) {
                if (!cls.isAnnotationPresent(OperatorName.class)) continue;
                OperatorName operatorName = cls.getAnnotation(OperatorName.class);
                RUNNER.addOperator(operatorName.value(), (Operator)cls.newInstance());
            }
        }
    }

    private static void addEvent(String eventPackage) throws Exception {
        List<Class<?>> clsList = ClassUtil.getClasses(eventPackage);
        if (!CollectionUtils.isEmpty(clsList)) {
            for (Class<?> cls : clsList) {
                if (!cls.isAnnotationPresent(EventName.class)) continue;
                EventName eventName = cls.getAnnotation(EventName.class);
                RUNNER.addFunctionOfServiceMethod(eventName.value(), cls.newInstance(), "deal", new Class[]{Object[].class}, null);
            }
        }
    }

    public static void addCustomOperatorAndEvent(String basePackage) throws Exception {
        RuleExecutor.addOperator(basePackage);
        RuleExecutor.addEvent(basePackage);
    }

    public static List<RuleVo> getRuleList(RuleEnum ruleEnum) {
        RuleEngineService ruleEngineService = SpringUtil.getBean(RuleEngineService.class);
        return ruleEngineService.getRuleList(ruleEnum);
    }

    public static Object execute(String express, Map<String, Object> ... map) throws Exception {
        DefaultContext context = new DefaultContext();
        if (map.length > 0 && map[0] != null) {
            for (Map.Entry<String, Object> entry : map[0].entrySet()) {
                context.put((Object)entry.getKey(), entry.getValue());
            }
        }
        DynamicParamsUtil.supportDynamicParams = true;
        return RUNNER.execute(express, (IExpressContext)context, null, false, false, null);
    }

    static {
        try {
            RuleExecutor.addLogic();
            RuleExecutor.addOperator(OperatorName.class.getPackage().getName());
            RuleExecutor.addEvent(EventName.class.getPackage().getName());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

