package cn.gtmap.ruleengine.config;

import cn.gtmap.ruleengine.util.RuleExecutor;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

/**
 * 规则引擎配置
 * @author 杨红杰
 * @date 2020-3-31 15:32
 */
@Component
public class RuleEngineConfig implements InitializingBean {
    private String basePackage;

    @Override
    public void afterPropertiesSet() throws Exception {
        // 添加自定义操作符、事件
        if (StringUtils.isNotBlank(basePackage)) {
            RuleExecutor.addCustomOperatorAndEvent(basePackage);
        }
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }
}
