package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.entity.XtUser;
import cn.gtmap.realestate.supervise.portal.dao.XtRegionMapper;
import cn.gtmap.realestate.supervise.portal.dao.XtUserMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 校验
 */
@Controller
@RequestMapping("validate")
public class XtUserValidateController {

    @Autowired
    private XtUserMapper xtUserMapper;

    @Autowired
    private XtRegionMapper xtRegionMapper;

    private static final String MSG = "msg";

    private static final String DATA = "data";

    private static final String SUCCESS = "success";

    private static final String FAILURE = "failure";

    private static final String ROLE_ADMIN = "ROLE_ADMIN";

    private CharSequence salt;

    /**
     * 校验用户
     * @param username
     * @param password
     * @return
     */
    @ResponseBody
    @RequestMapping("username-password")
    public Map<String, Object> validateUser(String username, String password){
        XtUser xtUser = xtUserMapper.getUserByLoginName(username);
        Map<String, Object> resultData = new HashMap<>();
        Md5PasswordEncoder md5PasswordEncoder = new Md5PasswordEncoder();
        String md5Pwd = md5PasswordEncoder.encodePassword(password, salt);
        if(null != xtUser && StringUtils.isNotBlank(xtUser.getLoginPassword())
                && xtUser.getLoginPassword().equals(md5Pwd)){
            resultData.put(MSG, SUCCESS);
            Map<String, Object> data = new HashMap<>();
            List<Map<String, Object>> roles = xtUserMapper.getRolesByUserName(username);
            List<XtRegion> regions = new ArrayList<>();
            for(Map<String, Object> role : roles){
                if(null != role.get("ROLE_NO") && role.get("ROLE_NO").toString().equals(ROLE_ADMIN)){
                    data.put("isAdmin", "true");
                }
                if(null != role.get("ROLE_ID")){
                    regions.addAll(xtRegionMapper.getRegionByRole(role.get("ROLE_ID").toString()));
                }
            }
            if(!data.containsKey("isAdmin")){
                data.put("isAdmin", "false");
            }
            data.put("regions", regions);
            resultData.put("data",data);
        }else{
            resultData.put(MSG, FAILURE);
        }
        return resultData;
    }

}
