package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtUser;
import cn.gtmap.realestate.supervise.portal.dao.XtUserMapper;
import cn.gtmap.realestate.supervise.portal.utils.LoginUserUtil;
import cn.gtmap.realestate.supervise.portal.utils.RSAUtils;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 修改系统用户信息
 */
@Controller
@RequestMapping("user-change")
public class XtUserChangeController extends BaseController {

    /**
     * 系统用户数据库映射
     */
    @Autowired
    private XtUserMapper xtUserMapper;

    private static final String MSG = "msg";

    private static final String SUCCESS = "success";

    private static final String FAILURE = "failure";

    private static final String CODE = "code";

    private CharSequence salt;

    @Autowired
    private LogController logController;

    /**
     * 变更系统用户密码
     *
     * @param username
     * @param password
     * @return
     */
    @ResponseBody
    @RequestMapping("change-password")
    public Map<String, Object> changeXtUserLoginPassword(HttpServletRequest request,
                                                         String username, String password, String newPassword) {
        Map<String, Object> resultMap = new HashMap<>();
        UserAuthDTO userInfos = getCurrentUser(request);
        if(ObjectUtils.isEmpty(userInfos)){
            resultMap.put(CODE, FAILURE);
            resultMap.put(MSG, "当前用户已被登出，请重新登陆");
            return resultMap;
        }
        if (StringUtils.isNotBlank(username)) {
            username = RSAUtils.decryptDataOnJava(username);
        }
        if (StringUtils.isNotBlank(password)) {
            password = RSAUtils.decryptDataOnJava(password);
        }
        if (StringUtils.isNotBlank(newPassword)) {
            newPassword = RSAUtils.decryptDataOnJava(newPassword);
        }

        String sensitiveAccount = xtUserMapper.getXtPropertiesByKey("sensitiveAccount");
        if (null != sensitiveAccount && sensitiveAccount.split(",").length != 0) {
            String[] sensitiveAccounts = sensitiveAccount.split(",");
            for (String sensitiveAccountTemp : sensitiveAccounts) {
                if (username.contains(sensitiveAccountTemp)) {
                    resultMap.put(CODE, FAILURE);
                    resultMap.put(MSG, "修改密码失败");
                    logController.log(username,"6", "修改密码失败：" + username, "基础支撑平台", IpUtil.getIpAddr(request));
                    return resultMap;
                }
            }
        }

        if (StringUtils.equals(username, newPassword)) {
            resultMap.put(CODE, FAILURE);
            resultMap.put(MSG, "密码不能与账号一致，请重新输入");
            return resultMap;
        }

        if (StringUtils.equals(username, StringUtils.reverse(newPassword))) {
            resultMap.put(CODE, FAILURE);
            resultMap.put(MSG, "密码不能与账号逆序一致，请重新输入");
            return resultMap;
        }

        Md5PasswordEncoder md5PasswordEncoder = new Md5PasswordEncoder();
        String md5Pwd = md5PasswordEncoder.encodePassword(password, salt);
        XtUser xtUser;
        if (StringUtils.isNotBlank(username) && StringUtils.isNotBlank(password)
            && StringUtils.isNotBlank(newPassword)) {
            xtUser = xtUserMapper.getUserByLoginName(username);
            if (null != xtUser && StringUtils.isNotBlank(xtUser.getLoginPassword())
                && xtUser.getLoginPassword().equals(md5Pwd)) {
                String newMd5Pwd = md5PasswordEncoder.encodePassword(newPassword, salt);
                // 根据配置项判断修改的密码不能和前几次相同
                String passwordDiffTime = xtUserMapper.getXtPropertiesByKey("passwordDiffTime");
                List<Map<String, String>> pwdList = xtUserMapper.getPasswordLogByLoginName(username, passwordDiffTime);
                boolean flag = false;
                for (Map<String, String> pwdMap : pwdList) {
                    if (StringUtils.equals(pwdMap.get("LOGINPASSWORD"), newMd5Pwd)) {
                        flag = true;
                        break;
                    }
                }
                if (flag) {
                    resultMap.put(CODE, FAILURE);
                    resultMap.put(MSG, "修改的密码和前几次相同");
                    return resultMap;
                } else {
                    XtUser xtUserNewPassword = new XtUser();
                    xtUserNewPassword.setLoginName(username);
                    xtUserNewPassword.setLoginPassword(newMd5Pwd);
                    xtUserMapper.updateUser(xtUserNewPassword);
                    // 将修改的密码插入表中
                    xtUserMapper.saveNewPasswordLog(username, newMd5Pwd, new Date());
                    resultMap.put(CODE, SUCCESS);
                    LoginUserUtil.cleanUserPasswordTooSimple(username);
                    logController.log(username,"6", "修改密码成功：" + username, "基础支撑平台", IpUtil.getIpAddr(request));
                }
            } else {
                resultMap.put(CODE, FAILURE);
                resultMap.put(MSG, "修改密码失败");
                logController.log(username,"6", "修改密码失败：" + username, "基础支撑平台", IpUtil.getIpAddr(request));
            }
        } else {
            resultMap.put(CODE, FAILURE);
            resultMap.put(MSG, "修改密码失败");
            logController.log(username,"6", "修改密码失败：" + username, "基础支撑平台", IpUtil.getIpAddr(request));
        }
        return resultMap;
    }

}
