package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.realestate.supervise.common.BaseController;

import cn.gtmap.realestate.supervise.entity.*;
import cn.gtmap.realestate.supervise.portal.dao.*;
import cn.gtmap.realestate.supervise.portal.service.XtRoleService;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import com.gtis.config.AppConfig;
import com.gtis.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * @author zhangyu
 * @version 1.0, 2017/6/19
 * @description 角色功能
 */

@Controller
@RequestMapping("role")
public class XtRoleController extends BaseController{

    @Autowired
    private XtRoleService xtRoleService;

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    private XtRoleMapper xtRoleMapper;
    @Autowired
    private RoleGroupMapper roleGroupMapper;
    @Autowired
    private RoleRegionMapper roleRegionMapper;
    @Autowired
    private XtRegionMapper xtRegionMapper;
    @Autowired
    private XtResourceMapper xtResourceMapper;
    @Autowired
    private RoleResourceMapper roleResourceMapper;
    @Autowired
    private Repo repository;

    @Autowired
    private LogController logController;


    @RequestMapping(value = "/roleList")
    public String roleList(Model model) {
        String portalUrl = AppConfig.getProperty("portal.url");
        model.addAttribute("portalUrl",portalUrl);
        String platformUrl = AppConfig.getProperty("platform.url");
        model.addAttribute("platformUrl",platformUrl);
        List<Map<String,Object>> groupList= xtResourceMapper.getGroup();
        model.addAttribute("groupList",groupList);
        return "role/listRole";

    }

    /**
     * 角色查询
     * @param pageable 分页参数信息
     * @param roleName 角色姓名
     * @param roleNo 角色编码
     * @return 角色分页信息
     */
    @ResponseBody
    @RequestMapping(value = "getRolePagesJson")
    public Object getAllRole(HttpServletRequest request, Pageable pageable,String roleName,String roleNo) {
        Map map = new HashMap();
        map.put("roleName", roleName);
        map.put("roleNo",roleNo);
        Page<HashMap> dataPaging = repository.selectPaging("getAllRoleByPage", map, pageable);
        UserAuthDTO userInfos = getCurrentUser(request);
        return dataPaging;
    }

    /**
     * 新增角色
     * @param roleName
     * @param roleNo
     * @param response
     * @throws IOException
     */
    @ResponseBody
    @RequestMapping(value = "addRole")
    public void addRole(HttpServletRequest request, String roleName,String roleNo, HttpServletResponse response)
        throws IOException {
        String msg;
        try {
            XtRole xtrole = xtRoleMapper.getRoleByRoleNo(roleNo);
            if(xtrole != null){
                msg = "该角色编号已被占用，请重新填写";
            }else {
                XtRole xtRole = new XtRole();
                String roleId = UUID.randomUUID().toString().replaceAll("-", "");
                xtRole.setRoleId(roleId);
                xtRole.setRoleName(roleName);
                xtRole.setRoleNo(roleNo);
                xtRoleService.addRole(xtRole);
                msg = "保存成功了";
            }
        } catch (Exception e) {
            msg = "保存过程出现异常";
        }
        response.getWriter().write(msg);
        response.getWriter().flush();
        UserAuthDTO userInfos = getCurrentUser(request);
        logController.log(userInfos.getXtUser().getUserName(),"4", "新增角色：" + roleName, "基础支撑平台", IpUtil.getIpAddr(request));
    }


    /**
     * 编辑角色
     * @param roleId
     * @param roleName
     * @param roleNo
     * @param response
     * @throws IOException
     */
    @ResponseBody
    @RequestMapping(value = "updateRole")
    public void updateRole(HttpServletRequest request, String roleId,String roleName,String roleNo, HttpServletResponse response) throws IOException {
        String msg;
        XtRole xtRole=new XtRole();
        xtRole.setRoleId(roleId);
        xtRole.setRoleName(roleName);
        xtRole.setRoleNo(roleNo);
        try {
            xtRoleService.updateRole(xtRole);
            msg = "修改成功";
        } catch (Exception e) {
            msg = "修改过程出现异常";
        }
        response.getWriter().write(msg);
        response.getWriter().flush();
        UserAuthDTO userInfos = getCurrentUser(request);
        logController.log(userInfos.getXtUser().getUserName(),"6", "编辑角色：" + roleName, "基础支撑平台", IpUtil.getIpAddr(request));
    }


    /**
     * 删除选中角色
     * @param ids
     * @param request
     * @param response
     * @throws IOException
     */
    @ResponseBody
    @RequestMapping("delSelectByRoleId")
    public void delSelectByRoleId(String ids,HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        String msg="";

        String roleIds[]=ids.split(",");
        String roleNames[] = new String[roleIds.length];
        for (int i = 0; i <roleIds.length ; i++) {
            try {
                roleNames[i] = xtRoleService.getRoleNameById(roleIds[i]);
                xtRoleService.delSelectByRoleId(roleIds[i]);
                msg = "success";
            } catch (Exception e) {
                msg = "删除过程发生错误,请刷新页面";
            }

        }

        response.getWriter().write(msg);
        response.getWriter().flush();
        UserAuthDTO userInfos = getCurrentUser(request);
        logController.log(userInfos.getXtUser().getUserName(),"5", "删除选中角色：" + StringUtils.join(roleNames)
            , "基础支撑平台", IpUtil.getIpAddr(request));
    }


    /**
     * 根据roleId获取已拥有和未拥有的组信息
     */
    @ResponseBody
    @RequestMapping("/getGroupsPagesJson")
    public Object getAllGroup(HttpServletRequest request, Pageable pageable,String roleId,boolean left){
        HashMap map = new HashMap();
        if (StringUtils.isNotBlank(roleId)) {
            map.put("roleId", roleId);
        }
        Page<HashMap> dataPaging;
        if (!left){
            dataPaging = repository.selectPaging("getRightGroupsByPage", map, pageable);
        }else{
            dataPaging = repository.selectPaging("getLeftGroupsByPage", map, pageable);
        }
        UserAuthDTO userInfos = getCurrentUser(request);
        return dataPaging;
    }


    /**
     *
     * 根据roleId和groupId增加角色用户关系表
     */
    @ResponseBody
    @RequestMapping("/addRGrel")
    public void saveRGrel(HttpServletRequest request, String roleId,String groupID) {
        if (StringUtils.isNotBlank(groupID) && StringUtils.isNotBlank(roleId)) {
            String[] groups = groupID.split("\\$");
            for (String groupId : groups) {
                if (StringUtils.isNotBlank(groupId)) {
                    XtRoleGroupRel xtRoleGroupRel = new XtRoleGroupRel();
                    xtRoleGroupRel.setRgrId(UUIDGenerator.generate18().replaceAll("-", ""));
                    xtRoleGroupRel.setRoleId(roleId);
                    xtRoleGroupRel.setGroupId(groupId);
                    entityMapper.saveOrUpdate(xtRoleGroupRel, xtRoleGroupRel.getRgrId());
                }
            }
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"4", "根据roleId和groupId增加角色用户关系表，roleId：" + roleId
                    + "，groupId：" + groups.toString(),
                "基础支撑平台",
                IpUtil
                    .getIpAddr(request));
        }
    }

    /**
     * @description  根据roleId和groupId删除角色用户关系表
     */
    @ResponseBody
    @RequestMapping("/delRGrel")
    public void delRGrel(HttpServletRequest request, String roleId,String groupID){
        if (StringUtils.isNotBlank(groupID) && StringUtils.isNotBlank(roleId)) {
            String[] groups = groupID.split("\\$");
            for (String groupId : groups) {
                if (StringUtils.isNotBlank(groupId)) {
                    HashMap map = new HashMap();
                    map.put("roleId", roleId);
                    map.put("groupId", groupId);

                   XtRoleGroupRel xtRoleGroupRel = roleGroupMapper.getRGrel(map);
                    if (null != xtRoleGroupRel) {
                        Example xtRoleGroupRelExample = new Example(XtRoleGroupRel.class);
                        xtRoleGroupRelExample.createCriteria().andEqualTo("rgrId", xtRoleGroupRel.getRgrId());
                        entityMapper.deleteByExample(xtRoleGroupRelExample);
                    }
                }
            }
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"5", "根据roleId和groupId删除角色用户关系表，roleId："
                    + roleId + "，groupId：" + groups.toString()
                , "基础支撑平台", IpUtil.getIpAddr(request));
        }
    }




    /**
     * @description  根据qhdm获取已拥有和未拥有行政区
     */
    @ResponseBody
    @RequestMapping("/getXzqhs")
    public Object getXzqhs(HttpServletRequest request, String roleID,boolean left){
        HashMap map = new HashMap();
        map.put("role_id",roleID);
        List<Map<String,Object>> result;
        if (left){
            List<Map<String,Object>> leftList = xtRegionMapper.getLeftXzqhs(map);
            result =  getNewList(leftList);
        }else {
            List<Map<String,Object>> rightList = xtRegionMapper.getRightXzqhs(map);
            result =  getNewList(rightList);
        }
        UserAuthDTO userInfos = getCurrentUser(request);
        return result;
    }



    /**
     * @description  根据roleId获取已拥有和未拥有资源
     */
    @ResponseBody
    @RequestMapping("/getResource")
    public Object getLeftResource(HttpServletRequest request, String roleID,String groupId,boolean left){
        HashMap map = new HashMap();
        map.put("roleId",roleID);
        map.put("groupId",groupId);
        List<Map<String,Object>> result;
        if (left){
            List<Map<String,Object>> leftList = xtResourceMapper.getLeftResource(map);
            result =  getNewList(leftList);
        }else {
            List<Map<String,Object>> rightList = xtResourceMapper.getRightResource(map);
            result =  getNewList(rightList);
        }
        UserAuthDTO userInfos = getCurrentUser(request);
        return result;
    }

    /**
     *
     * 根据roleId和groupId增加角色用户关系表
     */
    @ResponseBody
    @RequestMapping("/addRXrel")
    public void saveRXrel(HttpServletRequest request, String roleId,String qhdms) {
        if (StringUtils.isNotBlank(qhdms) && StringUtils.isNotBlank(roleId)) {
            String[] qhdm = qhdms.split(",");
            for (String qhdmtemp : qhdm) {
                HashMap map = new HashMap();
                HashMap map1 = new HashMap();
                map.put("roleId", roleId);
                map1.put("qhdm", qhdmtemp);
                XtRegion xtRegion = xtRegionMapper.getXzqh(map1);
                if (null != xtRegion && StringUtils.isNotBlank(xtRegion.getRegionId())){
                    map.put("region_id",xtRegion.getRegionId());
                }
                XtRoleRegionRel yxtRoleRegionRel = roleRegionMapper.getRXrel(map);
                if (yxtRoleRegionRel == null && StringUtils.isNotBlank(qhdmtemp)) {
                    XtRoleRegionRel xtRoleRegionRel = new XtRoleRegionRel();
                    xtRoleRegionRel.setRxrId(UUIDGenerator.generate18().replaceAll("-", ""));
                    xtRoleRegionRel.setRoleId(roleId);
                    xtRoleRegionRel.setRegionId(xtRegion.getRegionId());
                    entityMapper.saveOrUpdate(xtRoleRegionRel, xtRoleRegionRel.getRxrId());
                }
            }
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"4", "根据roleId和regionId增加角色用户关系表，"
                    + "roleId：" + roleId + "，regionId：" + qhdm.toString()
                , "基础支撑平台", IpUtil.getIpAddr(request));
        }
    }

    /**
     * @description  根据roleId和regionId删除角色用户关系表
     */
    @ResponseBody
    @RequestMapping("/delRXrel")
    public void delRXrel(HttpServletRequest request, String roleId,String qhdms){
        if (StringUtils.isNotBlank(qhdms) && StringUtils.isNotBlank(roleId)) {
            String[] qhdm = qhdms.split(",");
            for (String qhdmtemp : qhdm) {
                if (StringUtils.isNotBlank(qhdmtemp)) {
                    HashMap map = new HashMap();
                    HashMap map1 = new HashMap();
                    map.put("roleId", roleId);
                    map1.put("qhdm", qhdmtemp);
                    XtRegion xtRegion = xtRegionMapper.getXzqh(map1);
                    if (null != xtRegion){
                        map.put("region_id",xtRegion.getRegionId());
                    }
                    XtRoleRegionRel xtRoleRegionRel = roleRegionMapper.getRXrel(map);
                    if (null != xtRoleRegionRel) {
                        Example xtRoleXzqhRelExample = new Example(XtRoleRegionRel.class);
                        xtRoleXzqhRelExample.createCriteria().andEqualTo("rxrId", xtRoleRegionRel.getRxrId());
                        entityMapper.deleteByExample(xtRoleXzqhRelExample);
                    }
                }
            }
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"5", "根据roleId和regionId删除角色用户关系表，"
                    + "roleId：" + roleId + "，regionId：" + qhdm.toString()
                , "基础支撑平台", IpUtil.getIpAddr(request));
        }
    }


    /**
     *
     * 根据roleId和resourceId增加角色资源关系表
     */
    @ResponseBody
    @RequestMapping("/addRRrel")
    public void saveRRrel(HttpServletRequest request, String roleId,String resourceIds) {
        if (StringUtils.isNotBlank(resourceIds) && StringUtils.isNotBlank(roleId)) {
            String[] resourceId = resourceIds.split(",");
            for (String resourceIdtemp : resourceId) {

                HashMap map = new HashMap();
                HashMap map1 = new HashMap();
                map1.put("resourceId", resourceIdtemp);
                map.put("roleId", roleId);
                map.put("resourceId", resourceIdtemp);
                XtResource xtResource=xtResourceMapper.getResource(map1);
                XtResourceRoleRel yxtResourceRoleRel = roleResourceMapper.getRRrel(map);
                if (yxtResourceRoleRel == null && StringUtils.isNotBlank(resourceIdtemp)) {
                    XtResourceRoleRel xtResourceRoleRel = new XtResourceRoleRel();
                    xtResourceRoleRel.setRrrId(UUIDGenerator.generate18().replaceAll("-", ""));
                    xtResourceRoleRel.setRoleId(roleId);
                    xtResourceRoleRel.setGroupId(xtResource.getGroupId());
                    xtResourceRoleRel.setResourceId(resourceIdtemp);
                    entityMapper.saveOrUpdate(xtResourceRoleRel, xtResourceRoleRel.getRrrId());
                }
            }
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"4", "根据roleId和resourceId增加角色资源关系表，"
                    + "roleId：" + roleId + "，resourceId：" + resourceIds
                , "基础支撑平台", IpUtil.getIpAddr(request));
        }
    }

    /**
     * @description  根据roleId和resourceId删除角色资源关系表
     */
    @ResponseBody
    @RequestMapping("/delRRrel")
    public void delRRrel(HttpServletRequest request, String roleId,String resourceIds){
        if (StringUtils.isNotBlank(resourceIds) && StringUtils.isNotBlank(roleId)) {
            String[] resourceId = resourceIds.split(",");
            for (String resourceIdtemp : resourceId) {
                if (StringUtils.isNotBlank(resourceIdtemp)) {
                    HashMap map = new HashMap();
                    map.put("roleId", roleId);
                    map.put("resourceId", resourceIdtemp);
                    XtResourceRoleRel xtResourceRoleRel = roleResourceMapper.getRRrel(map);
                    if (null != xtResourceRoleRel) {
                        Example xtResourceRolRelExample = new Example(XtResourceRoleRel.class);
                        xtResourceRolRelExample.createCriteria().andEqualTo("rrrId", xtResourceRoleRel.getRrrId());
                        entityMapper.deleteByExample(xtResourceRolRelExample);
                    }
                }
            }
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"5", "根据roleId和resourceId删除角色资源关系表，"
                    + "roleId：" + roleId + "，resourceId：" + resourceIds
                , "基础支撑平台", IpUtil.getIpAddr(request));
        }
    }



    public List<Map<String,Object>> getNewList(List<Map<String,Object>> old){
        List<Map<String,Object>> newLeft = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(old)){
            for (Map map1 : old){
                Map<String,Object> newMap = new HashMap<>();
                Iterator<Map.Entry<String, Object>> it = map1.entrySet().iterator();
                while (it.hasNext()){
                    Map.Entry<String, Object> maptemp = it.next();
                    if (StringUtils.equals("ID",maptemp.getKey())){
                        newMap.put("id",maptemp.getValue());
                    }else if (StringUtils.equals("PID",maptemp.getKey())){
                        newMap.put("pId",maptemp.getValue());
                    }else if (StringUtils.equals("NAME",maptemp.getKey())){
                        newMap.put("name",maptemp.getValue());
                    }
                }
                newMap.put("open",true);
                newLeft.add(newMap);
            }
        }
        return newLeft;
    }




}