package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtResource;
import cn.gtmap.realestate.supervise.portal.dao.XtResourceMapper;
import cn.gtmap.realestate.supervise.portal.service.XtResourceService;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * @author zhangyu
 * @version 1.0, 2017/6/19
 * @description 资源功能
 */

@Controller
@RequestMapping("resource")
public class XtResourceController extends BaseController{

    @Autowired
    private XtResourceService xtResourceService;
    @Autowired
    private XtResourceMapper xtResourceMapper;
    @Autowired
    private Repo repository;
    @Autowired
    private EntityMapper entityMapper;

    @Autowired
    private LogController logController;

    @RequestMapping(value = "/resourceList")
    public String resourceList(Model model) {
        String portalUrl = AppConfig.getProperty("portal.url");
        model.addAttribute("portalUrl",portalUrl);
        return "resource/listResource";
    }

    /**
     * 资源查询
     * @param pageable 分页参数信息
     * @return 角色分页信息
     */

    @ResponseBody
    @RequestMapping(value = "getResourcePagesJson")
    public Object getAllResource(HttpServletRequest request, Pageable pageable, String resourceName, String resourceUrl) {
        Map map = new HashMap();
        map.put("resourceName", resourceName);
        map.put("resourceUrl",resourceUrl);
        Page<HashMap> dataPaging = repository.selectPaging("getAllResourceByPage", map, pageable);
        UserAuthDTO userInfos = getCurrentUser(request);
        return dataPaging;
    }

    //新增资源
    @ResponseBody
    @RequestMapping(value = "addResource")
    public void addResource(String resourceName,String resourceUrl,String parResourceId,
                            String groupId,String description,String defaultShow,String resourceCode,
                            HttpServletResponse response, HttpServletRequest request) throws IOException {
        String msg;
        HashMap paraMap = new HashMap();
        //保存resource信息
        XtResource xtResource=new XtResource();
        String resourceId=UUID.randomUUID().toString().trim().replaceAll("-", "");
        xtResource.setResourceId(resourceId);
        xtResource.setResourceName(resourceName);
        xtResource.setResourceUrl(resourceUrl);
        xtResource.setResourceCode(resourceCode);
        xtResource.setGroupId(groupId);
        xtResource.setParResourceId(parResourceId);
        xtResource.setDescription(description);
        xtResource.setDefaultShow(defaultShow);
        String orderNo = getLastOrderNo(parResourceId, groupId);
        if (StringUtils.isNotBlank(orderNo)){
            orderNo = Integer.parseInt(orderNo) + 1 + "";
        }else{
            orderNo = "1";
        }
        xtResource.setOrderNo(orderNo);
        //保存resource_group_rel信息
//        XtResourceGroupRel xtRgr = new XtResourceGroupRel();
//        String rgrId = UUID.randomUUID().toString().trim().replaceAll("-","");
//        xtRgr.setGroupId(groupId);
//        xtRgr.setResourceId(resourceId);
//        xtRgr.setRgrId(rgrId);

        try {
            xtResourceService.addResource(xtResource);
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"4", "新增资源：" + resourceName, "基础支撑平台", IpUtil.getIpAddr(request));
            msg = "保存成功了";
        } catch (Exception e) {
            //logger.info("保存成功", e);
            msg = "资源ID已存在，请重新填写资源ID";
        }
        response.getWriter().write(msg);
        response.getWriter().flush();

    }


    //编辑资源
    @ResponseBody
    @RequestMapping(value = "updateResource")
    public void updateResource(String resourceId ,String resourceName ,String resourceUrl
            ,String description ,String defaultShow ,String resourceCode ,HttpServletResponse response, HttpServletRequest request)
        throws IOException {
        String msg = null;
        Map map = new HashMap();
        map.put("resourceId",resourceId);
        map.put("resourceName",resourceName);
        map.put("resourceUrl",resourceUrl);
        map.put("description",description);
        map.put("defaultShow",defaultShow);
        map.put("resourceCode",resourceCode);
        if(StringUtils.equals("1",defaultShow)){
            Map param = new HashMap();
            XtResource xtResourceGroupId = xtResourceMapper.getResourceById(resourceId);
            param.put("groupId", xtResourceGroupId.getGroupId());
            List<XtResource> xtResourceList = xtResourceMapper.listResource(param);
            if(CollectionUtils.isNotEmpty(xtResourceList)){
                for(XtResource xtResource : xtResourceList){
                    if(StringUtils.isNotBlank(xtResource.getResourceUrl()) && "1".equals(xtResource.getDefaultShow())
                            && !StringUtils.equals(xtResourceGroupId.getResourceId(),xtResource.getResourceId())){
                        msg = "修改失败：“"+xtResource.getResourceName()+"”已为默认展示";
                    }
                }
            }
        }
        if(StringUtils.isBlank(msg)){
            try {
                xtResourceService.updateResource(map,resourceId,defaultShow);
                UserAuthDTO userInfos = getCurrentUser(request);
                logController.log(userInfos.getXtUser().getUserName(),"6", "编辑资源：" + resourceName, "基础支撑平台", IpUtil
                    .getIpAddr(request));
                msg = "success";
            } catch (Exception e) {
                msg = "修改过程出现异常";
            }
        }
        response.getWriter().write(msg);
        response.getWriter().flush();
    }

    //删除选中资源
    @ResponseBody
    @RequestMapping("delSelectByResourceId")
    public void delSelectByResourceId(String resourceId,HttpServletResponse response, HttpServletRequest request)
            throws IOException {
        String msg;

        try {
            XtResource xtResource = xtResourceService.getResourceById(resourceId);
            xtResourceService.delSelectByResourceId(resourceId);
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"5", "删除选中资源：" + xtResource.getResourceName()
                , "基础支撑平台", IpUtil.getIpAddr(request));
            msg = "success";
        } catch (Exception e) {
            msg = "删除过程发生错误,请刷新页面";

        }

        response.getWriter().write(msg);
        response.getWriter().flush();
    }

    @ResponseBody
    @RequestMapping(value = "getResourcePagesByGroupJson")
    public Object getAllResource(HttpServletRequest request, String resourceName,String resourceUrl,String groupId) {
        HashMap map = new HashMap();
        map.put("groupId",groupId);
        map.put("resourceName", resourceName);
        map.put("resourceUrl",resourceUrl);
        map.put("parResourceId","");
        if (StringUtils.isBlank(resourceName) && StringUtils.isBlank(resourceUrl)){
            map.put("level","1");
        }
        List<Map<String,Object>> resourceList;
        resourceList = xtResourceService.getChildNodes(map);
        if (null != resourceList) {
            resourceList = getChildren(resourceList);
        }
        return resourceList;
    }

    @ResponseBody
    @RequestMapping("turnNum")
    public String turnNum(HttpServletRequest request, String action,String resourceId,String groupId){
        String message = "success";
        if (StringUtils.isNotBlank(resourceId) && StringUtils.isNotBlank(groupId)){
            HashMap paraMap = new HashMap();
            paraMap.put("resourceId",resourceId);
            XtResource xtResource = xtResourceMapper.getResource(paraMap);
            if (null != xtResource){
                if (StringUtils.isNotBlank(xtResource.getParResourceId())){
                    paraMap.put("parResourceId",xtResource.getParResourceId());
                }else {
                    paraMap.put("parResourceId",null);
                }
            }
            paraMap.put("groupId",groupId);
            paraMap.put("level","1");
            List<Map<String,Object>> resourceList;
            resourceList = xtResourceService.getChildNodes(paraMap);
            if (StringUtils.equals(action, "up")){
                message = turnOrder(resourceId,resourceList);
                if (StringUtils.equals(message,"1")){
                    message = "无法上移";
                }else{
                    message = "success";
                }
            }else{
                Collections.reverse(resourceList);
                message = turnOrder(resourceId,resourceList);
                if (StringUtils.equals(message,"1")){
                    message = "无法下移";
                }else{
                    message = "success";
                }
            }
        }
        UserAuthDTO userInfos = getCurrentUser(request);
        logController.log(userInfos.getXtUser().getUserName(),"6", "调整资源次序：" + resourceId, "基础支撑平台", IpUtil.getIpAddr(request));
        return  message;
    }

    /**
     * 查看某资源可用的按钮
     * @param resourceId 页面上选中的资源ID
     * @return 按钮信息
     */
    @ResponseBody
    @RequestMapping("checkButtons")
    public List<Map> checkButtons(HttpServletRequest request, String resourceId){
        HashMap paraMap = new HashMap();
        if (StringUtils.isNotBlank(resourceId)){
            paraMap.put("resourceId",resourceId);
        }
        return xtResourceService.getButtonsByres(paraMap);
    }

    @ResponseBody
    @RequestMapping("saveButtons")
    public void saveButtons(HttpServletRequest request, String btnIds,String resourceId){
        UserAuthDTO userInfos = getCurrentUser(request);
        logController.log(userInfos.getXtUser().getUserName(),"4", "保存按钮，resourceId：" + resourceId
                + "，btnId：" + btnIds
            , "基础支撑平台", IpUtil.getIpAddr(request));
        xtResourceService.saveButtons(btnIds,resourceId);
    }

    public List<Map<String,Object>> getChildren(List<Map<String,Object>> resourcelist){

        List<Map<String,Object>> childrenResult =  new ArrayList<>();

        for (Map<String,Object> map : resourcelist){
            List<Map<String,Object>> childrenList;
            if (map.get("RESOURCEID") != null ){
                Map paraMap = new HashMap();
                paraMap.put("parResourceId",map.get("RESOURCEID").toString());
                paraMap.put("level","1");
                childrenList = xtResourceService.getChildNodes(paraMap);
                getChildren(childrenList);
            }else{
                childrenList =  new ArrayList<>();
            }
            map.put("children", childrenList);

        }
        childrenResult.addAll(resourcelist);
        return  childrenResult;
    }



    /**
     * 获取每层节点的子节点
     */
    public List getChildNodes(String parResourceId){
        return null;
    }


    /**
     * 资源顺序交换
     * @param resourceId 页面上选中的资源ID
     * @param resourceList 与该资源同级所有资源
     * @return 交换成功信息
     */
    public String turnOrder(String resourceId,List<Map<String,Object>> resourceList){
        String message = "";
        HashMap paraMap = new HashMap();
        if (CollectionUtils.isNotEmpty(resourceList)) {
            for (int a = 0; a < resourceList.size(); a++) {
                if(StringUtils.equals(resourceId,resourceList.get(a).get("RESOURCEID").toString())){
                    if (a == 0){
                        message = "1";
                        break;
                    }else{
                        paraMap.put("resourceId",resourceList.get(a - 1).get("RESOURCEID").toString());
                        XtResource resource1 = xtResourceMapper.getResource(paraMap);
                        paraMap.put("resourceId",resourceList.get(a).get("RESOURCEID").toString());
                        XtResource resource2 = xtResourceMapper.getResource(paraMap);
                        if (null != resource1 && null != resource2){
                            String orderNo1 = resource1.getOrderNo();
                            String orderNo2 = resource2.getOrderNo();
                            resource1.setOrderNo(orderNo2);
                            resource2.setOrderNo(orderNo1);
                            xtResourceMapper.updateResourceByKey(resource1);
                            xtResourceMapper.updateResourceByKey(resource2);
                        }
                        break;
                    }
                }
            }
        }
        return message;
    }


    /**
     * 获取该级别资源中最大序号
     * @param
     * @return 交换成功信息
     */
    public String getLastOrderNo(String parResourceId,String groupId){
        HashMap paraMap = new HashMap();
        String orderNo = "";
        if (StringUtils.isNotBlank(parResourceId)){
            paraMap.put("parResourceId",parResourceId);
        }else{
            paraMap.put("parResourceId",null);
        }
        paraMap.put("groupId",groupId);
        paraMap.put("level","1");
        List<Map<String,Object>> resourceList = xtResourceService.getChildNodes(paraMap);
        if (CollectionUtils.isNotEmpty(resourceList)){
            for(int a = resourceList.size(); a > 0; a--){
                Map<String,Object> resource = resourceList.get(a-1);
                if (null != resource.get("ORDERNO")) {
                    orderNo = resource.get("ORDERNO").toString();
                    break;
                }
            }
//            Map<String,Object> resource = resourceList.get(resourceList.size()-1);
//            if (null != resource.get("ORDERNO")) {
//                orderNo = resource.get("ORDERNO").toString();
//            }
        }
        return orderNo;
    }
}
