package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.portal.dao.XtRegionMapper;
import cn.gtmap.realestate.supervise.portal.service.XtRegionService;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @version 1.0, 2017/6/23
 * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
 * @description
 */
@Controller
@RequestMapping("xzqh")
public class XtRegionController extends BaseController{
    @Autowired
    private XtRegionService xtRegionService;
    @Autowired
    private XtRegionMapper xtRegionMapper;
    @Autowired
    EntityMapper entityMapper;

    @Autowired
    private LogController logController;

    @RequestMapping(value = "/xzqhList")
    public String roleList(Model model) {
        String portalUrl = AppConfig.getProperty("portal.url");
        model.addAttribute("portalUrl", portalUrl);
        String platformUrl = AppConfig.getProperty("platform.url");
        model.addAttribute("platformUrl",platformUrl);
        HashMap map = new HashMap();
        List<Map<String,Object>> fdmList = xtRegionMapper.getXzqhByPage(map);
        if (CollectionUtils.isNotEmpty(fdmList)){
            model.addAttribute("fdmList",fdmList);
        }
        return "xzqh/xzqhList";
    }



    /**
     * 行政区划查询
     * @param qhmc 行政区划名称
     * @param qhdm 行政区划编码
     * @return 行政区划分页信息
     */

    @ResponseBody
    @RequestMapping(value = "getXzqhPagesJson")
    public Object getAllRole(HttpServletRequest request, String qhmc,String qhdm) {
        HashMap paraMap = new HashMap();
        paraMap.put("fdm", AppConfig.getProperty("region.qhdm"));
        paraMap.put("qhdm",qhdm);
        paraMap.put("qhmc",qhmc);
        if (StringUtils.isBlank(qhdm) && StringUtils.isBlank(qhmc)){
            paraMap.put("level","1");
        }
        List<Map<String,Object>> regionLook;
        regionLook = xtRegionService.getChildNodes(paraMap);
        if (null != regionLook) {
            regionLook = getGoodChildren(regionLook);
        }
        UserAuthDTO userInfos = getCurrentUser(request);
        return regionLook;
    }


    /*
     * 子行政区划查询
     *  @param qhdm
     *  @param qhmc
     *  @decription 一次只查一代
     */
    public List<Map<String,Object>> getChildNodes(String qhdm, String qhmc){
        List<Map<String,Object>> children;
            HashMap paraMap = new HashMap();
            paraMap.put("fdm","000000");
            paraMap.put("qhdm",qhdm);
            paraMap.put("qdhm",qhmc);
            if (StringUtils.isBlank(qhdm) && StringUtils.isBlank(qhmc)){
                paraMap.put("level","1");
            }
            children = xtRegionService.getChildNodes(paraMap);
        return children;
    }

    /*
     * 子行政区划查询
     *  @decription 查出所有子行政区划
     */
    public List<Map<String,Object>> getGoodChildren(List<Map<String,Object>> children){
        List<Map<String,Object>> childrenResult =  new ArrayList<>();
        for (Map<String,Object> map : children){
            if (map.containsKey("QHJB") && map.get("QHJB") != null && map.get("QHJB").toString() != "乡级"){
                List<Map<String,Object>> paraChildren;
                if (map.get("QHDM") != null ){
                    HashMap paraMap = new HashMap();
                    paraMap.put("fdm",map.get("QHDM").toString());
                    paraMap.put("level","1");
                    paraChildren = xtRegionService.getChildNodes(paraMap);
                    getGoodChildren(paraChildren);
                }else{
                    paraChildren =  new ArrayList<>();
                }
                map.put("children",paraChildren);
            }
        }
        childrenResult.addAll(children);
        return  childrenResult;
    }


    /**
     * 行政区更新
     * @param request 表单信息
     * @param region_id 行政区划ID
     * @return 部门分页信息
     */
    @ResponseBody
    @RequestMapping(value = "addOrUpdateXzqh")
    public String addOrUpdate(HttpServletRequest request,String region_id,XtRegion newXtegion) throws IOException,NullPointerException {
        UserAuthDTO userInfos = getCurrentUser(request);
        String msg = "";
        HashMap map =  new HashMap();
        if (StringUtils.isBlank(region_id)) {
            if (request  != null) {
                XtRegion xtRegion = new XtRegion();
                xtRegion.setRegion_id(UUIDGenerator.generate18());
                xtRegion.setQhdm(request.getParameter("addQHDM"));
                xtRegion.setQhmc(request.getParameter("addQHMC"));
                xtRegion.setQhjb(request.getParameter("addQHJB"));
                xtRegion.setFdm(request.getParameter("addFDM").trim());
                String geocordX = request.getParameter("addGEOCORDX");
                if (StringUtils.isNotBlank(geocordX)){
                    xtRegion.setGeocordx(Double.parseDouble(geocordX));
                }
                String geocordY = request.getParameter("addGEOCORDY");
                if (StringUtils.isNotBlank(geocordY)){
                    xtRegion.setGeocordy(Double.parseDouble(geocordY));
                }

                try {
                    entityMapper.saveOrUpdate(xtRegion,xtRegion.getQhdm());
                    logController.log(userInfos.getXtUser().getUserName(),"4", "新增行政区划：" + request.getParameter("addQHMC")
                        , "基础支撑平台", IpUtil.getIpAddr(request));
                    msg = "success";
                } catch (Exception e) {
                    msg = "区域DM已存在";
                }
            }
        }else{
            map.put("region_id",region_id);
            XtRegion yXtRegion = xtRegionService.getXzqh(map);
            if (null != yXtRegion) {
                yXtRegion.setQhdm(request.getParameter("QHDM"));
                yXtRegion.setQhmc(request.getParameter("QHMC"));
                yXtRegion.setQhjb(request.getParameter("QHJB"));
                yXtRegion.setFdm(request.getParameter("FDM"));
                String geocordX = request.getParameter("GEOCORDX");
                if (StringUtils.isNotBlank(geocordX)){
                    yXtRegion.setGeocordx(Double.parseDouble(geocordX));
                }
                String geocordY = request.getParameter("GEOCORDY");
                if (StringUtils.isNotBlank(geocordY)){
                    yXtRegion.setGeocordy(Double.parseDouble(geocordY));
                }
                try {
                    entityMapper.saveOrUpdate(yXtRegion,region_id);
                    logController.log(userInfos.getXtUser().getUserName(),"6", "修改行政区划：" + request.getParameter("QHMC")
                        , "基础支撑平台", IpUtil.getIpAddr(request));
                    msg = "success";
                } catch (Exception e) {
                    msg = "区域DM已存在";
                }

            }
        }

        return msg;
    }


    @ResponseBody
    @RequestMapping("delSelectByqhdms")
    public void delSelectByRoleId(HttpServletRequest request, String qhdm)
            throws IOException {
        HashMap map = new HashMap();
        String qhdms[]=qhdm.split("\\$");
        if (qhdms != null && qhdms.length > 0){
            map.put("qhdms",qhdms);
            xtRegionService.delXzqhByIds(map);
            xtRegionService.updateParentRegin(qhdms[1]);
        }
        UserAuthDTO userInfos = getCurrentUser(request);
        logController.log(userInfos.getXtUser().getUserName(),"5", "删除行政区划：" + qhdm, "基础支撑平台", IpUtil.getIpAddr(request));
    }

    @ResponseBody
    @RequestMapping("getXzqhsByRoleId")
    public Object getXzqhsByRoleId(HttpServletRequest request, String RoleId)
            throws IOException {
        HashMap map = new HashMap();
        map.put("role_id",RoleId);
        List<String> qhdms = xtRegionService.getXzqhsByRoleId(map);
        return qhdms;
    }

}
