package cn.gtmap.realestate.supervise.portal.web;


import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtDate;
import cn.gtmap.realestate.supervise.portal.service.XtDateService;
import cn.gtmap.realestate.supervise.portal.utils.DateEnum;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import com.gtis.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author wangyang
 * @version 1.0, 2018/8/6
 * @description 系统日历功能
 */

@Controller
public class XtDateController extends BaseController {

    @Autowired
    private XtDateService ed;

    @Autowired
    private LogController logController;

   @RequestMapping("/date")
   public String  getDateInfo(Model model){
   return "date/date";
  }

    /**
     *  插入所选年份的信息
     * @param year
     * @return
     * @throws ParseException
     * @throws IOException
     */
    @ResponseBody
    @RequestMapping("/insertEveryDay")
    public Object insertEveryDay(HttpServletRequest request, String year) throws ParseException,IOException{
        UserAuthDTO userInfos = getCurrentUser(request);
        String result;
        String newMy =  StringUtils.substringBeforeLast(year,"-")+"%";
        List<XtDate> xtDateList= ed.selectDayByMonth(newMy);
          if(xtDateList.size()>0){
              result ="fail";
              logController.log(userInfos.getXtUser().getUserName(),"4", "插入所选年份的信息：" + year + "-失败"
                  , "基础支撑平台", IpUtil.getIpAddr(request));
          }
         else {
              List<XtDate> everydayList = getEveryDay(Integer.parseInt(year));
              try {
                  ed.insertEveryDay(everydayList);
                  result = "success";
                  logController.log(userInfos.getXtUser().getUserName(),"4", "插入所选年份的信息：" + year + "-成功"
                      , "基础支撑平台", IpUtil.getIpAddr(request));
              } catch (Exception ex) {
                  result = "fail";
                  logController.log(userInfos.getXtUser().getUserName(),"4", "插入所选年份的信息：" + year + "-失败"
                      , "基础支撑平台", IpUtil.getIpAddr(request));
              }
          }
         return  result;
    }


    /**
     *
     *获得当月所有日期的信息
     * @throws IOException
     */
    @ResponseBody
    @RequestMapping("getMonthDay")
    public  Object getMonthDay() throws  IOException{
        List<XtDate> allEveryDayList = ed.selectMonthDay();
        return  allEveryDayList;

    }


    /**
     * 更新具体一天的 工作类型和备注
     * @param id
     * @param xttype
     * @param xttext
     * @return
     * @throws IOException
     */
   @ResponseBody
  @RequestMapping("updateType")
    public Object updateType(HttpServletRequest request, String id,Integer xttype,String xttext) throws  IOException{
       UserAuthDTO userInfos = getCurrentUser(request);
       String result;
       try{
           ed.updateDateType(id, xttype,xttext);
             result="success";
             XtDate xtDate = ed.selectOneDayById(id);
           logController.log(userInfos.getXtUser().getUserName(),"6", "更新具体一天的-工作类型和备注：" + xtDate.getXtdate()
               , "基础支撑平台", IpUtil.getIpAddr(request));
       }catch (Exception  ex){
           ex.printStackTrace();
          result="fail";
       }
      return  result;
    }

    /**
     * 查询前台传过来的年份还有月份 到数据库查询 当月所有的日期
     */
  @ResponseBody
  @RequestMapping("selectMDay")
  public   Object  selectDayByMonth(String my) throws  IOException{
    String newMy =  StringUtils.substringBeforeLast(my,"-")+"%";
       List<XtDate> xtDateList= ed.selectDayByMonth(newMy);
      //System.out.println(xtDateList.toString());
       return  xtDateList;
  }

    /**
     * 获取 具体一天的 信息
     * @param date
     *
     */
     @ResponseBody
    @RequestMapping("getOneDayId")
    public  XtDate  selectOneDayByDate(String date) throws ParseException, IOException {
             SimpleDateFormat aDateformat=new SimpleDateFormat("yyyy-MM-dd");
             Date  newDate = aDateformat.parse(date);
             XtDate oneDay=  ed.selectOneDayByDate(newDate);
              oneDay.setSxtdate(aDateformat.format(oneDay.getXtdate()));
             return  oneDay;

   }


    public static List< XtDate> getEveryDay(int year) throws ParseException {
        List< XtDate> allList=new ArrayList<XtDate>();
        String[] weekDays = {DateEnum.星期日.toString(),DateEnum.星期一.toString(),DateEnum.星期二.toString(),DateEnum.星期三.toString(),DateEnum.星期四.toString(),DateEnum.星期五.toString(),DateEnum.星期六.toString()};
        Calendar calendar = Calendar.getInstance();
        for (int i = 1; i <= 12; i++) {
            calendar.set(year, i, 1);
            long next = calendar.getTimeInMillis();
            calendar.add(Calendar.MONTH, -1);
            while (calendar.getTimeInMillis() != next) {
                XtDate everyday=new  XtDate();
                String id = UUIDGenerator.generate18();
                everyday.setXtid(id);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
                Date cDate=calendar.getTime();
                String  sDate=format.format(cDate);
                everyday.setXtdate(format.parse(sDate));
                int w = calendar.get(Calendar.DAY_OF_WEEK) - 1;
                if (w < 0) {
                    w = 0;
                }

                everyday.setXtrq(weekDays[w]);
                if(weekDays[w].equals("星期日")|| weekDays[w].equals("星期六")){
                    everyday.setXttype(2); //2是节假日
                }else {
                    everyday.setXttype(1); //1是工作日
                }

                int j = 1;
                calendar.add(Calendar.DAY_OF_MONTH, j++);
                allList.add(everyday);
            }
        }
        return  allList;
    }
}
