package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtUser;
import cn.gtmap.realestate.supervise.entity.XtUserRoleRel;
import cn.gtmap.realestate.supervise.portal.dao.UserRoleMapper;
import cn.gtmap.realestate.supervise.portal.dao.XtUserMapper;
import cn.gtmap.realestate.supervise.portal.service.XtUserService;
import cn.gtmap.realestate.supervise.utils.HttpClientUtil;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import com.gtis.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * Created by Administrator on 2017/6/19.
 */
@Controller
public class UserManagerController extends BaseController {
    @Autowired
    private Repo repository;

    @Autowired
    private XtUserMapper xtUserMapper;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private XtUserService xtUserService;

    @Autowired
    private LogController logController;

    Md5PasswordEncoder md5PasswordEncoder = new Md5PasswordEncoder();

    @RequestMapping("/userManage")
    public String TurnUser(Model model) {
        String portalUrl = AppConfig.getProperty("portal.url");
        model.addAttribute("portalUrl", portalUrl);
        String platformUrl = AppConfig.getProperty("platform.url");
        model.addAttribute("platformUrl", platformUrl);
        return "login/list";
    }

    /**
     * 获取平台用户列表——常州市
     *
     * @param
     * @throws IOException
     */
    @ResponseBody
    @RequestMapping("/getUsersFromPlat")
    public void getUsersFromPlat(HttpServletRequest request) {
        String url = AppConfig.getProperty("flex.url");
        UserAuthDTO userAuthDTO = super.getCurrentUser(request);
        HashMap paraMap = new HashMap();
        paraMap.put("events", "GetPersonList");
        if (userAuthDTO != null) {
            String sessionId = userAuthDTO.getToken();
            if (StringUtils.isNotBlank(sessionId)) {
                paraMap.put("SessionID", sessionId);
            }
        }
        paraMap.put("ResultType", "Json");
        String userJson = "";
        try {
            userJson = HttpClientUtil.sendHttpClient(url, paraMap);
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        //String userJson = "{\"DataSet\":[{\"table\":{\"ID\":\"7595380\",\"PersonName\":\"吴春兰\",\"LogonName\":\"22222\"}},{\"table\":{\"ID\":\"7595381\",\"PersonName\":\"吴春林\",\"LogonName\":\"1234\"}}]}";
        if (StringUtils.isNotBlank(userJson)) {
            JSONObject jsonObject = JSON.parseObject(userJson);
            if (jsonObject.containsKey("Table")) {
                JSONArray jsonArray = (JSONArray) (jsonObject.get("Table"));
                if (null != jsonArray) {
                    JSONObject jo1;
                    for (int i = 0; i < jsonArray.size(); i++) {
                        jo1 = (JSONObject) jsonArray.get(i);
                        String loginName;
                        boolean mark = false;//false 只更新
                        if (jo1.containsKey("LOGONNAME")) {
                            loginName = jo1.get("LOGONNAME").toString();
                            XtUser xtUser = xtUserMapper.getUserByLoginName(loginName);
                            if (xtUser == null) {
                                xtUser = new XtUser();
                                mark = true;
                            }
                            if (null != jo1.get("ID")) {
                                xtUser.setUserId(jo1.get("ID").toString());
                            }
                            if (null != jo1.get("PERSONNAME")) {
                                xtUser.setUserName(jo1.get("PERSONNAME").toString());
                            }
                            if (null != jo1.get("LOGONNAME")) {
                                xtUser.setLoginName(jo1.get("LOGONNAME").toString());
                            }
                            if (null != jo1.get("PASSWORD")) {
                                xtUser.setLoginPassword(jo1.get("PASSWORD").toString());
                            }
                            if (null != jo1.get("SEX")) {
                                xtUser.setUserSex(jo1.get("SEX").toString());
                            }
                            if (null != jo1.get("PERSONCODE")) {
                                xtUser.setUserNo(jo1.get("PERSONCODE").toString());
                            }
                            if (null != jo1.get("ISPAUSE")) {
                                xtUser.setIsValid(Integer.parseInt(jo1.get("ISPAUSE").toString()));
                            }
                            if (null != jo1.get("REMARK")) {
                                xtUser.setRemark(jo1.get("REMARK").toString());
                            }
                            if (null != jo1.get("MOBILEPHONE")) {
                                xtUser.setMobilePhone(jo1.get("MOBILEPHONE").toString());
                            }
                            if (null != jo1.get("SERIALNO")) {
                                xtUser.setUserRank(jo1.get("SERIALNO").toString());
                            }
                            if (mark) {
                                xtUserMapper.saveUser(xtUser);
                            } else {
                                xtUserMapper.updateUser(xtUser);
                            }
                        }

                    }
                }
            }

        }
    }


    /**
     * 保存用户信息
     *
     * @param response
     * @throws IOException
     */
    @ResponseBody
    @RequestMapping("/saveUser")
    public void saveUser(HttpServletResponse response, HttpServletRequest request, String username, String loginname
        , String password, String email, String mobilephone, String isValid) throws IOException {
        String result;
        String userId = UUID.randomUUID().toString().trim().replaceAll
            ("-", "");
        try {
            // 验证敏感账户
            String sensitiveAccount = xtUserMapper.getXtPropertiesByKey("sensitiveAccount");
            boolean flag = false;
            if (sensitiveAccount != null) {
                String[] sensitiveAccountArray = sensitiveAccount.split(",");
                for (int i = 0; i < sensitiveAccountArray.length; i++) {
                    if (StringUtils.equals(sensitiveAccountArray[i].toLowerCase(), loginname.toLowerCase())) {
                        flag = true;
                        break;
                    }
                }
            }
            if (!flag) {
                XtUser xtUser = xtUserMapper.loadUserByUserName(loginname);
                if (xtUser != null) {
                    result = "该登录名已被占用，请选择其他登录名";

                } else {

                    XtUser user = new XtUser();

                    user.setUserName(username);
                    user.setLoginName(loginname);

                    String md5Pwd = md5PasswordEncoder.encodePassword(password, null);
                    user.setLoginPassword(md5Pwd);
                    user.setEmail(email);
                    user.setMobilePhone(mobilephone);
                    user.setIsValid(Integer.parseInt(isValid));
                    user.setUserId(userId);

                    xtUserMapper.saveUser(user);
                    result = "true";
                }
            } else {
                result = "禁止使用敏感账户作为账户名";
            }
        } catch (Exception e) {
            result = "fail";
            e.printStackTrace();
        }
        response.getWriter().write(result);
        response.getWriter().flush();
        UserAuthDTO userInfos = getCurrentUser(request);
        logController.log(userInfos.getXtUser().getUserName(),"4", "保存用户信息：" + username, "基础支撑平台", IpUtil.getIpAddr(request));
    }

    /**
     * 删除用户的信息
     *
     * @param
     * @return
     */
    @ResponseBody
    @RequestMapping("/delSelected")
    public void delSelect(HttpServletResponse response, HttpServletRequest request, String ids)
        throws Exception {
        String result;
        String[] useridAll = ids.split(",");
        String[] userNames = new String[useridAll.length];
        List<String> list = Arrays.asList(useridAll);
        try {
            for (int i = 0; i < list.size(); i++) {
                XtUser xtUser = xtUserMapper.getUserById(list.get(i));
                xtUserMapper.deleteByPrimaryKey(list.get(i));
                if(!ObjectUtils.isEmpty(xtUser)){
                    userNames[i] = xtUser.getUserName();
                }
            }
            result = "success";
        } catch (Exception e) {
            result = "删除过程发生错误,请刷新页面";
        }
        response.getWriter().write(result);
        response.getWriter().flush();
        UserAuthDTO userInfos = getCurrentUser(request);
        logController.log(userInfos.getXtUser().getUserName(),"5", "删除用户的信息：" + StringUtils.join(userNames)
            , "基础支撑平台", IpUtil.getIpAddr(request));

    }

    /**
     * 显示用户台账信息
     */
    @RequestMapping("/userList")
    public String UserList(Model model) {
        String portalUrl = AppConfig.getProperty("portal.url");
        model.addAttribute("portalUrl", portalUrl);
        return "login/testfont";
    }

    /**
     * 根据userName和loginName查询信息
     */
    @ResponseBody
    @RequestMapping("/getUserPagesJson")
    public Object getUserPages(HttpServletRequest request, Pageable pageable, String username, String loginname) {
        Map map = new HashMap();
        map.put("username", username);
        map.put("loginname", loginname);
        Page<HashMap> dataPaging = repository.selectPaging("getUserByPage", map, pageable);
        UserAuthDTO userInfos = getCurrentUser(request);
        return dataPaging;
    }

    /**
     * 根据userid来改is_valid的值（改用户状态）
     */
    @ResponseBody
    @RequestMapping("/changValid")
    public void changValid(HttpServletRequest request, HttpServletResponse response, String ids, String valid) throws Exception {
        String result;
        try {

            String[] useridAll = ids.split(",");
            List<String> list = Arrays.asList(useridAll);
            Map map = new HashMap();
            for (int i = 0; i < list.size(); i++) {
                map.put("valid", valid);
                map.put("userid", list.get(i));
                xtUserMapper.changeValid(map);
                UserAuthDTO userInfos = getCurrentUser(request);
                logController.log(userInfos.getXtUser().getUserName(),"6", "根据userid来改is_valid的值（改用户状态），"
                        + "userid：" + list.get(i) + "，is_valid：" + valid
                    , "基础支撑平台", IpUtil.getIpAddr(request));
            }
            result = "success";
        } catch (Exception e) {
            result = "fail";
        }
        response.getWriter().write(result);
        response.getWriter().flush();

    }

    /**
     * 修改用户信息前先查用户信息
     */
    @ResponseBody
    @RequestMapping("/selectUser")
    public void editUser(HttpServletRequest request, HttpServletResponse response, String loginname) throws IOException {
        XtUser xtUser;
        xtUser = xtUserMapper.loadUserByUserName(loginname);
        //model.addAttribute("user",xtUser);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("username", xtUser.getUserName());
        jsonObject.put("loginname", xtUser.getLoginName());
        jsonObject.put("email", xtUser.getEmail());
        jsonObject.put("mobilephone", xtUser.getMobilePhone());
        jsonObject.put("officephone", xtUser.getOfficePhone());
        jsonObject.put("homephone", xtUser.getHomePhone());
        jsonObject.put("birthday", xtUser.getBirthday());
        jsonObject.put("sex", xtUser.getUserSex());
        jsonObject.put("address", xtUser.getAddress());
        jsonObject.put("password", xtUser.getLoginPassword());
        String jsonString = jsonObject.toJSONString();
        response.getWriter().write(jsonString);
        response.getWriter().flush();
    }

    /**
     * 修改用户信息
     */
    @ResponseBody
    @PostMapping("/editUser")
    public void editUser(HttpServletRequest request, HttpServletResponse response, String username, String loginname, String password, String email,
                         String mobilephone) throws Exception {
        XtUser xtUser = new XtUser();
        String result;
        try {
            xtUser.setUserName(username);
            xtUser.setLoginName(loginname);
            xtUser.setLoginPassword(password);
            xtUser.setEmail(email);
            xtUser.setMobilePhone(mobilephone);
            xtUserMapper.updateUser(xtUser);
            result = "success";
        } catch (Exception e) {
            result = "fail";
            e.printStackTrace();
        }
        response.getWriter().write(result);
        response.getWriter().flush();
        UserAuthDTO userInfos = getCurrentUser(request);
        logController.log(userInfos.getXtUser().getUserName(),"6", "修改用户信息：" + username, "基础支撑平台", IpUtil.getIpAddr(request));
    }

    /**
     * @author lx
     * @description 根据useid获取已拥有和未拥有的角色信息
     */
    @ResponseBody
    @RequestMapping("/getRolesPagesJson")
    public Object getAllRole(HttpServletRequest request, Pageable pageable, String userid, boolean left) {
        HashMap map = new HashMap();
        if (StringUtils.isNotBlank(userid)) {
            map.put("userid", userid);
        }
        Page<HashMap> dataPaging;
        if (!left) {
            dataPaging = repository.selectPaging("getRightRolesByPage", map, pageable);
        } else {
            dataPaging = repository.selectPaging("getLeftRolesByPage", map, pageable);
        }
        UserAuthDTO userInfos = getCurrentUser(request);
        return dataPaging;
    }


    /**
     * @author lx
     * @description 根据useid和roleid增加角色用户关系表
     */
    @ResponseBody
    @RequestMapping("/addURrel")
    public void saveURrel(HttpServletRequest request, String roleID, String userid) {
        if (StringUtils.isNotBlank(roleID) && StringUtils.isNotBlank(userid)) {
            String[] roles = roleID.split("\\$");
            for (String roleid : roles) {
                if (StringUtils.isNotBlank(roleid)) {
                    HashMap map = new HashMap();
                    map.put("userid", userid);
                    map.put("roleid", roleid);
                    XtUserRoleRel xtUserRoleRel1 = userRoleMapper.getURrel(map);
                    if (xtUserRoleRel1 == null) {
                        XtUserRoleRel xtUserRoleRel = new XtUserRoleRel();
                        xtUserRoleRel.setUrrId(UUIDGenerator.generate18().replaceAll("-", ""));
                        xtUserRoleRel.setRoleId(roleid);
                        xtUserRoleRel.setUserId(userid);
                        entityMapper.saveOrUpdate(xtUserRoleRel, xtUserRoleRel.getUrrId());
                    }
                }
            }
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"4", "根据useid和roleid增加角色用户关系表，"
                    + "userid：" + userid + "，roleId" + roleID
                , "基础支撑平台", IpUtil.getIpAddr(request));
        }
    }

    /**
     * @author lx
     * @description 根据useid和roleid删除角色用户关系表
     */
    @ResponseBody
    @RequestMapping("/delURrel")
    public void delURrel(HttpServletRequest request, String roleID, String userid) {
        if (StringUtils.isNotBlank(roleID) && StringUtils.isNotBlank(userid)) {
            String[] roles = roleID.split("\\$");
            for (String roleid : roles) {
                if (StringUtils.isNotBlank(roleid)) {
                    HashMap map = new HashMap();
                    map.put("userid", userid);
                    map.put("roleid", roleid);
                    XtUserRoleRel xtUserRoleRel = userRoleMapper.getURrel(map);
                    if (null != xtUserRoleRel) {
                        Example xtUserRoleRelExample = new Example(XtUserRoleRel.class);
                        xtUserRoleRelExample.createCriteria().andEqualTo("urrId", xtUserRoleRel.getUrrId());
                        entityMapper.deleteByExample(xtUserRoleRelExample);
                    }
                }
            }
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"5", "根据useid和roleid删除角色用户关系表，"
                    + "useid：" + userid + "，roleId：" + roleID
                , "基础支撑平台", IpUtil.getIpAddr(request));
        }
    }

    /**
     * @return 用户名集合
     * @author lx
     * @description 用于别的工程调用
     */
    @ResponseBody
    @RequestMapping("/getAllXtUser")
    public List<Map> getAllXtUser(HttpServletRequest request) {
        return xtUserService.getAllXtUser();
    }

}
