package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtResource;
import cn.gtmap.realestate.supervise.portal.dao.XtGroupMapper;
import cn.gtmap.realestate.supervise.utils.CloneUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/8/1.
 */
@Controller
public class UserEnterController extends BaseController {

    @Autowired
    private XtGroupMapper xtGroupMapper;

    @RequestMapping("/UserIn")
    public String Userin(String groupno, String resourceCode, Model model, HttpServletRequest request, HttpServletResponse response){

        List<XtGroup> groupList = xtGroupMapper.getAllgroup();
        for(XtGroup group:groupList){
            if(StringUtils.isNotBlank(group.getGroupNo())){
                if(groupno.equals(group.getGroupNo())){
                    model.addAttribute("title",group.getGroupName());
                    model.addAttribute("menuType",group.getMenuType());
                    break;
                }
            }
        }

        UserAuthDTO userAuthDTO = getCurrentUser(request);
        if(null == userAuthDTO){
            String loginPage = AppConfig.getProperty("default.loginPage");
            try {
                response.sendRedirect(loginPage);
                return null;
            } catch (IOException e) {
                return "common/401";
            }
        }

        LinkedHashMap<String,LinkedHashMap<String,XtResource>> resourceList = userAuthDTO.getResourceMap();
        if(!resourceList.containsKey(groupno)){
            return "common/401";
        }

        LinkedHashMap<String,XtResource> firstResource = resourceList.get(groupno);
        //克隆到新的Map对象中，方便操作，也不会影响正常权限
        LinkedHashMap<String,XtResource> copyResource = CloneUtil.clone(firstResource);
        if(StringUtils.isNotBlank(resourceCode) && MapUtils.isNotEmpty(copyResource)){
            XtResource xtResource;
            XtResource targetResource = null;

            for (Map.Entry<String,XtResource> entry : copyResource.entrySet()) {
                xtResource = entry.getValue();
                if(null != targetResource){
                    getChildResource(xtResource,resourceCode);
                }else {
                    targetResource = getChildResource(xtResource,resourceCode);
                }
            }
            if(null == targetResource){
                return "common/401";
            }
        }

        model.addAttribute("resource",copyResource);
        String platformUrl =  AppConfig.getProperty("platform.url");
        model.addAttribute("platformUrl",platformUrl);
        String loginSuccessPage =  AppConfig.getProperty("default.loginSuccessPage");
        if(loginSuccessPage.contains("${")){
            String getAppConfUrl = loginSuccessPage.substring(loginSuccessPage.indexOf("{")+1, loginSuccessPage.indexOf("}"));
            getAppConfUrl = AppConfig.getProperty(getAppConfUrl);
            model.addAttribute("loginSuccessPage",getAppConfUrl + loginSuccessPage.substring(loginSuccessPage.indexOf("}")+1));
        }else{
            model.addAttribute("loginSuccessPage",loginSuccessPage);
        }
        String portalUrl = AppConfig.getProperty("portal.url");
        model.addAttribute("portalUrl",portalUrl);
        model.addAttribute("isAdmin",userAuthDTO.getIsAdmin());
        model.addAttribute("isPasswordTooSimple", userAuthDTO.isPasswordTooSimple());
        return "login/cxxt";
    }

    private XtResource getChildResource(XtResource xtResource,String resourceCode){
        if(null != xtResource && StringUtils.isNotBlank(resourceCode)){
            XtResource localXtResource = null;
            xtResource.setDefaultShow("0");
            if(StringUtils.isNotBlank(xtResource.getResourceCode()) && StringUtils.equals(xtResource.getResourceCode(),resourceCode)){
                xtResource.setDefaultShow("1");
                return xtResource;
            }else{
                List<XtResource> childResource = xtResource.getChildResources();
                if(CollectionUtils.isNotEmpty(childResource)){
                    for(XtResource xtResource1 : childResource){
                        if(null != localXtResource){
                            getChildResource(xtResource1,resourceCode);
                        }else{
                            localXtResource = getChildResource(xtResource1,resourceCode);
                        }
                        if(localXtResource != null){
                            xtResource.setDefaultShow("1");
                        }
                    }
                    return localXtResource;
                }else{
                    return null;
                }
            }
        } else {
          return null;
        }
    }

}
