package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.portal.dao.XtRegionMapper;
import cn.gtmap.realestate.supervise.portal.model.RoleResourceDTO;
import cn.gtmap.realestate.supervise.portal.service.RoleResourceService;
import cn.gtmap.realestate.supervise.portal.utils.LoginUserUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author hqz
 * @version 1.0, 2017/5/27
 * @description 登录功能
 */
@Controller
@RequestMapping(value = "remote")
public class SecuritySSOHandleController {

    private String role_admin = AppConfig.getProperty("role.admin");

    @Autowired
    private RoleResourceService roleResourceService;

    @Autowired
    private XtRegionMapper xtRegionMapper;

    /**
     * 验证用户是否登录
     *
     * @param uuid cookie ID
     * @return 用户信息
     */
    @RequestMapping(value = "/validUser")
    @ResponseBody
    public UserAuthDTO validUser(String uuid) {
        UserAuthDTO userAuthDTO = null;
        if (StringUtils.isNotBlank(uuid)) {
            userAuthDTO = LoginUserUtil.getLoginUserMap(uuid);
        }
        return userAuthDTO;
    }

    /**
     * 校验用户是否有当前资源地址使用权限
     *
     * @param url
     * @param uuid
     * @param groupNo
     * @return
     */
    @RequestMapping(value = "/validResource")
    @ResponseBody
    public boolean validResource(String url, String uuid, String groupNo) {
        if (StringUtils.isNotBlank(url) && StringUtils.isNotBlank(uuid)) {
            List<RoleResourceDTO> roleResourceDTOs = roleResourceService.findRoleResourceDTObyUrl(url, groupNo);
            if (CollectionUtils.isEmpty(roleResourceDTOs)) {
                return true;
            }
            UserAuthDTO userAuthDTO = LoginUserUtil.getLoginUserMap(uuid);
            if (null != userAuthDTO) {

                for (GrantedAuthority ga : userAuthDTO.getAuthorities()) {
                    if (ga.getAuthority().trim().equals(role_admin)) {
                        return true;
                    }
                    for (RoleResourceDTO roleResourceDTO : roleResourceDTOs) {
                        if (roleResourceDTO.getRoleNo().trim().equals(ga.getAuthority().trim())) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }


    /**
     * @version 1.0, 2017/7/17
     * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
     * @description 获取单个行政区划
     */
    @RequestMapping(value = "/getXzqhOne")
    @ResponseBody
    public XtRegion getXzqhOne(String qhdm) {
        XtRegion xtRegion = new XtRegion();
        if (StringUtils.isNotBlank(qhdm)) {
            HashMap paraMap = new HashMap();
            paraMap.put("qhdm", qhdm);
            xtRegion = xtRegionMapper.getXzqh(paraMap);
        }
        return xtRegion;
    }


    /**
     * @version 1.0, 2017/7/17
     * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
     * @description 获取行政区划及其下属行政区划
     */
    @RequestMapping(value = "/getXzqhNext")
    @ResponseBody
    public List<XtRegion> getXzqhNext(String qhdm) {
        List<XtRegion> xtRegionList = new ArrayList<>();
        if (StringUtils.isNotBlank(qhdm)) {
            HashMap paraMap = new HashMap();
            paraMap.put("qhdm", qhdm);
            //level传空值搜此行政区划及其所有子行政区划
            paraMap.put("level", "");
            xtRegionList = xtRegionMapper.getXzqhNext(paraMap);
        }
        return xtRegionList;
    }

    /**
     * @version 1.0, 2017/7/17
     * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
     * @description 获取行政区划及其下属行政区划
     */
    @RequestMapping(value = "/getCurruserRegion")
    @ResponseBody
    public List<XtRegion> getCurruserRegion(String userid) {
        List<XtRegion> xtRegionList = new ArrayList<>();
        if (StringUtils.isNotBlank(userid)) {
            HashMap paraMap = new HashMap();
            paraMap.put("userid", userid);
            //level传空值搜此行政区划及其所有子行政区划
            //paraMap.put("level","");
            xtRegionList = xtRegionMapper.getCurruserRegion(paraMap);
        }
        return xtRegionList;
    }

    /**
     * 获取当前用户所具有的系统列表
     *
     * @param userid 用户ID
     * @return 系统列表
     */
    @RequestMapping(value = "/getCurruserGroup")
    @ResponseBody
    public List<XtGroup> getCurruserGroup(String userid) {
        List<XtGroup> xtGroupList = new ArrayList<>();
        if (StringUtils.isNotBlank(userid)) {
            HashMap paraMap = new HashMap();
            paraMap.put("userid", userid);
            xtGroupList = xtRegionMapper.getCurruserGroup(paraMap);
        }
        return xtGroupList;
    }

}
