package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.portal.service.XtRegionService;
import cn.gtmap.realestate.supervise.utils.HttpClientUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author hqz
 * @version 1.0, 2017/5/27
 * @description 登录功能
 */
@Controller
public class LoginController extends BaseController {
    
    @Autowired
    private AuthenticationManager authenticationManager;

    @Autowired
    private AuthenticationSuccessHandler authenticationSuccessHandler;

    @Autowired
    private XtRegionService xtRegionService;

    // 陕西省行政区划代码
    private static final String QHDM_SX = "610000";

    @RequestMapping(value = "loginPage")
    public ModelAndView showLoginPage(@RequestParam(defaultValue = "") String username,
                                      @RequestParam(defaultValue = "") String password,

                                      HttpServletRequest request, HttpServletResponse response, String Token,String autoLogin) {

        ModelAndView model = new ModelAndView();


        model.addObject("PUBLIC_KEY", AppConfig.getProperty("RSA.PUBLIC_KEY"));
        model.addObject("PRIVATE_KEY", AppConfig.getProperty("RSA.PRIVATE_KEY"));

        String loginFailureTimes = AppConfig.getProperty("login.failure.locked.times");
        if (StringUtils.isBlank(loginFailureTimes)) {
            loginFailureTimes = "0";
        }
        model.addObject("loginFailureTimes", loginFailureTimes);

        String defaultLoginSuccessPage = AppConfig.getProperty("default.loginSuccessPage");
        if (StringUtils.isBlank(defaultLoginSuccessPage)) {
            defaultLoginSuccessPage = "";
        }
        model.addObject("defaultLoginSuccessPage", defaultLoginSuccessPage);

        String regionQhdm = AppConfig.getProperty("region.qhdm");

        model.addObject("applicationName", AppConfig.getProperty("application.name"));
        model.addObject("applicationDescription", AppConfig.getProperty("application.description"));
        Map<String, Object> param = new HashMap<>();
        param.put("qhdm", regionQhdm);
        model.addObject("regionQhmc", xtRegionService.getXzqh(param).getQhmc());


        if (StringUtils.equals(autoLogin, "true")) {
            model.addObject("username", username);
            model.addObject("password", password);
            model.setViewName("appraise/login");
        }else{
            model.setViewName("common/login");
        }

        if (StringUtils.isBlank(username) && StringUtils.isBlank(Token)) {
            return model;
        }
        String handelLoginName = "";
        if (StringUtils.isNotBlank(Token)) {
            String flexUrl = AppConfig.getProperty("flex.url");
            if (StringUtils.isNotBlank(flexUrl)) {
                Map<String, String> paraMap = new HashMap<>();
                paraMap.put("SessionID", Token);
                paraMap.put("events", "GetOperatorInfo");
                paraMap.put("ResultType", "Json");
                try {
                    String jsonStr = HttpClientUtil.sendHttpClient(flexUrl, paraMap);
                    JSONObject jo = JSON.parseObject(jsonStr);
                    if (jo.containsKey("Status")) {
                        JSONArray ja = (JSONArray) jo.get("Status");
                        if (null != ja && ja.size() > 0) {
                            JSONObject curUser = (JSONObject) ja.get(0);
                            if (curUser.containsKey("LogonName")) {
                                String loginName = (String) curUser.get("LogonName");
                                handelLoginName = loginName + "_token_" + Token;
                            }
                        }

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (StringUtils.isNotBlank(handelLoginName)) {
            username = handelLoginName;
            password = "token";

            try {
                UsernamePasswordAuthenticationToken authRequest =
                    new UsernamePasswordAuthenticationToken(username, password);
                Authentication authentication = authenticationManager.authenticate(authRequest);
                SecurityContextHolder.getContext().setAuthentication(authentication);
                HttpSession session = request.getSession();
                session.setAttribute("SPRING_SECURITY_CONTEXT", SecurityContextHolder.getContext()); // 这个非常重要，否则验证后将无法登陆

                authenticationSuccessHandler.onAuthenticationSuccess(request, response, authentication);
            } catch (IOException e) {
                e.printStackTrace();
            } catch (ServletException e) {
                e.printStackTrace();
            } catch (BadCredentialsException e) {
                model.addObject("error", "1");
            }
        }

        return model;
    }

    @RequestMapping(value = "/changepassword")
    public String changePassowd(Model model, HttpServletRequest request) {
        UserAuthDTO userInfos = getCurrentUser(request);
        if (!ObjectUtils.isEmpty(userInfos)) {
            model.addAttribute("username", userInfos.getUsername());
            String portalUrl = AppConfig.getProperty("portal.url");
            model.addAttribute("portalUrl", portalUrl);
            model.addAttribute("PUBLIC_KEY", AppConfig.getProperty("RSA.PUBLIC_KEY"));
            return "login/change_password";
        } else {
            return "common/login";
        }
    }

    @RequestMapping(value = "/404")
    public String show404Page(Model model) {
        return "common/404";
    }

    @RequestMapping(value = "/401")
    public String show401Page(Model model) {
        return "common/401";
    }

}
