package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.realestate.supervise.entity.XtCzLog;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 记录日志
 * @author szh
 */
@Controller
@RequestMapping("/log")
public class LogController {
    @Autowired
    private EntityMapper entityMapper;

    @Autowired
    private Repo repository;

    /**
     * 日志接口
     * @param czyh 操作用户
     * @param czlx 操作类型
     * @param gnmc 功能名称
     * @param xtmc 系统名称
     * @param ip ip地址
     */
    @RequestMapping("save")
    @ResponseBody
    public void log(String czyh, String czlx, String gnmc, String xtmc, String ip){
        XtCzLog xtCzLoglog = new XtCzLog(UUIDGenerator.generate(),czyh,new Date(System.currentTimeMillis()),czlx,gnmc,xtmc,ip);
        entityMapper.saveOrUpdate(xtCzLoglog,xtCzLoglog.getId());
    }

    /**
     * 操作日志台账入口
     * @return
     */
    @RequestMapping("logTable")
    public String log(Model model){
        model.addAttribute("portalUrl",AppConfig.getProperty("portal.url"));
        return "log/log";
    }

    /**
     * 操作日志台账
     * @param czyh 操作用户
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @return
     */
    @RequestMapping("getLog")
    @ResponseBody
    public Object getLog(Pageable pageable, String czyh, String kssj, String jssj){
        Map<String, String> map = new HashMap<>(5);
        if (StringUtils.isNotBlank(czyh)) {
            map.put("czyh",czyh);
        }
        if (StringUtils.isNotBlank(kssj)) {
            map.put("kssj",kssj);
        }
        if (StringUtils.isNotBlank(jssj)) {
            map.put("jssj",jssj);
        }
        return repository.selectPaging("getLogByPage", map, pageable);
    }
}
