package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtUser;
import cn.gtmap.realestate.supervise.portal.dao.XtGroupMapper;
import cn.gtmap.realestate.supervise.portal.dao.XtRegionMapper;
import cn.gtmap.realestate.supervise.portal.utils.StringUrlUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2018/10/26
 * @author hqz
 * @description 平台首页调用接口
 */
@Controller
@RequestMapping("")
public class IndexController extends BaseController {

    @Autowired
    private XtRegionMapper xtRegionMapper;

    @Autowired
    private XtGroupMapper xtGroupMapper;

    /**
     * 获取平台对应的系统参数
     * @return 系统参数
     */
    @RequestMapping(value="index",produces="application/json;charset=utf-8")
    @ResponseBody
    public Object applicationInfo(HttpServletRequest request){
        Map<String,String> applicationInfoMap = new HashMap<>();
        //获取当前登陆用户
        UserAuthDTO userInfos = getCurrentUser(request);
        if(null != userInfos){
            applicationInfoMap.put("userName",userInfos.getXtUser().getUserName());
        }
        //获取系统名称
        String applicationName = AppConfig.getProperty("application.name");
        String applicationSize = AppConfig.getProperty("application.size");
        applicationInfoMap.put("applicationName",applicationName);
        applicationInfoMap.put("applicationSize",applicationSize);
        String regionDm = AppConfig.getProperty("region.qhdm");
        applicationInfoMap.put("regionDm",regionDm);
        String applicationDescription = AppConfig.getProperty("application.description");
        applicationInfoMap.put("applicationDescription",applicationDescription);
        return applicationInfoMap;
    }

    /**
     * 获取系统资源
     * @return
     */
    @RequestMapping(value="getResources",produces="application/json;charset=utf-8")
    @ResponseBody
    public Object getResources(HttpServletRequest request){
        UserAuthDTO userInfos = getCurrentUser(request);
        if(null != userInfos){
            XtUser xtUser = userInfos.getXtUser();
            List<XtGroup> xtGroupList = xtGroupMapper.getAllgroup();
            Boolean isAdmin = userInfos.getIsAdmin();
            Map<String,Map<String,Object>> groupMaps = new LinkedHashMap<>();
            List<XtGroup> hasGroupList;
            if(isAdmin){
                hasGroupList = xtGroupList;
            }else{
                HashMap paraMap = new HashMap();
                paraMap.put("userid",xtUser.getUserId());
                hasGroupList = xtRegionMapper.getCurruserGroup(paraMap);
            }
            if(CollectionUtils.isNotEmpty(hasGroupList) && CollectionUtils.isNotEmpty(xtGroupList)){
                Map<String,Object> groupMap;
                String url;
                String portalUrl = AppConfig.getProperty("portal.url");
                for(XtGroup xtGroup : xtGroupList){
                    groupMap = new HashMap<>();
                    groupMap.put("isHas",false);
                    groupMap.put("group",xtGroup);
                    for(XtGroup xtGroupHas : hasGroupList){
                        if(StringUtils.equals(xtGroup.getGroupNo(),xtGroupHas.getGroupNo())){
                            groupMap.put("isHas",true);
                            if(StringUtils.isNotBlank(xtGroup.getGroupUrl())){
                                url = StringUrlUtil.handleUrl(xtGroup.getGroupUrl(),null);
                            }else{
                                url =  portalUrl + "/UserIn?groupno=" + xtGroup.getGroupNo();
                            }

                            groupMap.put("url",url);
                            break;
                        }
                    }
                    groupMaps.put(xtGroup.getGroupNo(),groupMap);
                }
            }
            return groupMaps;
        }else{
            return null;
        }
    }

}
