package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.realestate.supervise.common.BaseController;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.portal.dao.XtGroupMapper;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * Created by Administrator on 2017/6/19.
 */
@Controller
public class GroupManagerController extends BaseController {
    @Autowired
    private Repo repository;

    @Autowired
    private XtGroupMapper xtGroupMapper;

    @Autowired
    private LogController logController;

    @RequestMapping("/group")
    public String TurnUser(Model model) {
        String portalUrl = AppConfig.getProperty("portal.url");
        model.addAttribute("portalUrl", portalUrl);
        String platformUrl = AppConfig.getProperty("platform.url");
        model.addAttribute("platformUrl", platformUrl);
        return "login/group";
    }

    /**
     * 保存group信息
     *
     * @param response
     * @throws java.io.IOException
     */
    @ResponseBody
    @RequestMapping("/saveGroup")
    public void saveGroup(HttpServletResponse response, HttpServletRequest request
        , String groupname, String groupno, String menuType, String groupDes, String groupOrder, String groupUrl) throws IOException {
        String result;
        String groupid = UUID.randomUUID().toString().trim().replaceAll
            ("-", "");
        try {
            UserAuthDTO userInfos = getCurrentUser(request);
            XtGroup xtgroup = xtGroupMapper.getGroupByGroupNo(groupno);
            if (xtgroup != null) {
                result = "该分组编号已被占用，请重新填写";
                logController.log(userInfos.getXtUser().getUserName(),"4", "保存子系统信息："
                        + xtgroup.toString() + "，" + result, "基础支撑平台", IpUtil.getIpAddr(request));
            } else {
                XtGroup xtGroup = new XtGroup();

                xtGroup.setGroupNo(groupno);
                xtGroup.setGroupName(groupname);
                xtGroup.setGroupId(groupid);
                xtGroup.setMenuType(menuType);
                xtGroup.setGroupDes(groupDes);
                xtGroup.setGroupOrder(groupOrder);
                xtGroup.setGroupUrl(groupUrl);
                xtGroupMapper.saveGroup(xtGroup);
                result = "true";
                logController.log(userInfos.getXtUser().getUserName(),"4", "保存子系统信息："
                    + groupname, "基础支撑平台", IpUtil.getIpAddr(request));
            }
        } catch (Exception e) {
            result = "fail";
            e.printStackTrace();
        }
        response.getWriter().write(result);
        response.getWriter().flush();
    }

    /**
     * 删除group的信息
     *
     * @param
     * @return
     */
    @ResponseBody
    @RequestMapping("/delGroup")
    public void delSelect(HttpServletResponse response, HttpServletRequest request, String ids)
        throws Exception {
        String result;

        try {

            String[] groupidAll = ids.split(",");
            String[] groupNames = new String[groupidAll.length];
            List<String> list = Arrays.asList(groupidAll);
            for (int i = 0; i < list.size(); i++) {
                XtGroup xtGroup = xtGroupMapper.getGroupByGroupId(list.get(i));
                xtGroupMapper.deleteByPrimaryKey(list.get(i));
                if (!ObjectUtils.isEmpty(xtGroup)) {
                    groupNames[i] = xtGroup.getGroupName();
                }
            }
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"5", "删除子系统信息："
                + StringUtils.join(groupNames), "基础支撑平台", IpUtil.getIpAddr(request));
            result = "success";
        } catch (Exception e) {
            result = "删除过程发生错误,请刷新页面";
        }
        response.getWriter().write(result);
        response.getWriter().flush();

    }


    /**
     * 根据groupName和groupNo查询信息
     */
    @ResponseBody
    @RequestMapping("/getGroupPagesJson")
    public Object getUserPages(Pageable pageable, String groupname, String groupno) {
        Map map = new HashMap();
        map.put("groupname", groupname);
        map.put("groupno", groupno);
        Page<HashMap> dataPaging = repository.selectPaging("getGroupByPage", map, pageable);
        return dataPaging;
    }


    /**
     * 修改用户信息前先查用户信息
     */
    @ResponseBody
    @RequestMapping("/selectGroup")
    public void selectGroup(HttpServletResponse response, String groupid) throws IOException {
        XtGroup xtGroup;
        xtGroup = xtGroupMapper.selectByPrimaryKey(groupid);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("groupid", xtGroup.getGroupId());
        jsonObject.put("groupname", xtGroup.getGroupName());
        jsonObject.put("groupno", xtGroup.getGroupNo());
        String jsonString = jsonObject.toJSONString();
        response.getWriter().write(jsonString);
        response.getWriter().flush();
    }

    /**
     * 修改用户信息
     */
    @ResponseBody
    @RequestMapping("/editGroup")
    public void editGroup(HttpServletResponse response, HttpServletRequest request, String groupid, String
        groupname, String groupno, String menuType, String groupDes, String groupOrder, String groupUrl) throws Exception {
        XtGroup xtGroup = new XtGroup();
        String result;
        try {
            xtGroup.setGroupName(groupname);
            xtGroup.setGroupNo(groupno);
            xtGroup.setGroupId(groupid);
            xtGroup.setMenuType(menuType);
            xtGroup.setGroupDes(groupDes);
            xtGroup.setGroupOrder(groupOrder);
            xtGroup.setGroupUrl(groupUrl);
            xtGroupMapper.updateGroup(xtGroup);
            UserAuthDTO userInfos = getCurrentUser(request);
            logController.log(userInfos.getXtUser().getUserName(),"6", "修改子系统信息：" + xtGroup.toString()
                , "基础支撑平台", IpUtil.getIpAddr(request));
            result = "success";
        } catch (Exception e) {
            result = "fail";
        }
        response.getWriter().write(result);
        response.getWriter().flush();
    }


    /**
     * 根据groupid来查resource信息
     */
    @ResponseBody
    @RequestMapping("/getResourceByGroupIdPagesJson")
    public Object getResourceByGroupid(Pageable pageable, String groupid) {
        Map map = new HashMap();
        map.put("groupid", groupid);
        Page<HashMap> dataPaging = repository.selectPaging("getResourceByGroupByPage", map, pageable);
        return dataPaging;
    }

}
