package cn.gtmap.realestate.supervise.portal.web;

import cn.gtmap.realestate.supervise.portal.service.FetchResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by 徐涛 on 2018-7-20.
 */
@Controller
@RequestMapping("fetch-resource")
public class FetchResourceController {

    @Autowired
    private FetchResourceService fetchResourceService;

    @ResponseBody
    @RequestMapping("byLoginName")
    public Map<String, Object> fetchResourceByLoginName(String loginName, String groupNo){
        Map<String, Object> data = new HashMap<>();
        data.put("data", fetchResourceService.FetchResourceByLoginName(loginName, groupNo));
        return data;
    }

}
