package cn.gtmap.realestate.supervise.portal.utils;

import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;

/**
 * @author hqz
 * @version 1.0, 2017/8/2
 * @description 配置URl处理工具类
 */
public class StringUrlUtil {

    /**
     * 占位符开始标识常量
     * @author hqz
     * @description 占位符开始标识常量,如${protal.url}
     */
    private static final String START_SIGN = "${";

    /**
     * 占位符结束标识常量
     * @author hqz
     * @description 占位符结束标识常量，如${protal.url}
     */
    private static final String END_SIGN = "}";

    public static String handleUrl(String url,String token){
        String finalUrl = null;
        if(StringUtils.isNotBlank(url)){
            if(url.trim().startsWith(START_SIGN)){
                String prokey = url.substring(url.indexOf(START_SIGN) + START_SIGN.length(),url.indexOf(END_SIGN));
                if(StringUtils.isNotBlank(prokey)){
                    String appUrl = AppConfig.getProperty(prokey);
                    finalUrl = appUrl + splitUrl(url);
                    if(StringUtils.isNotBlank(token)){
                        if(StringUtils.contains(finalUrl,"?")){
                            finalUrl = finalUrl + "&Token="+token;
                        } else {
                            finalUrl = finalUrl + "?Token="+token;
                        }

                    }
                }

            }
        }
        return finalUrl;
    }

    public static String splitUrl(String url){
        String newUrl = "";
        if(StringUtils.isNotBlank(url) && url.trim().startsWith(START_SIGN)){
            newUrl = url.substring(url.indexOf("/"));
        } else {
            newUrl = url;
        }
        return newUrl;
    }
}
