package cn.gtmap.realestate.supervise.portal.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.crypto.password.PasswordEncoder;

/**
 * @author hqz
 * @version 1.0, 2017/5/24
 * @description 加密器生成类
 */
public class PasswordEncoderFactoryBean implements FactoryBean,InitializingBean {
    private static Logger logger = LoggerFactory
            .getLogger(PasswordEncoderFactoryBean.class);
    private String type;
    private PasswordEncoder passwordEncoder;
    private CharSequence salt;

    /**
     * 适应不同加密器，通过spring配置实现不同加密，目前只实现了MD5加密器
     */
    public void afterPropertiesSet() {
        if ("md5".equals(type)) {
            this.passwordEncoder = new MyMd5PasswordEncoder(salt);
            logger.info("MD5加密");
        }
    }

    public Object getObject() {
        return passwordEncoder;
    }

    public Class getObjectType() {
        return PasswordEncoder.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setType(String type) {
        this.type = type;
    }


    public void setSalt(CharSequence salt) {
        this.salt = salt;
    }
}
