package cn.gtmap.realestate.supervise.portal.utils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

/**
 * @author hqz
 * @version 1.0, 2017/5/24
 * @description MD5加密器
 */
public class MyMd5PasswordEncoder implements PasswordEncoder {

    private Md5PasswordEncoder md5PasswordEncoder = new Md5PasswordEncoder();
    private CharSequence salt;

    public MyMd5PasswordEncoder() {
    }

    public MyMd5PasswordEncoder(CharSequence salt) {
        this.salt = salt;
    }

    public String encode(CharSequence rawPassword) {
        return md5PasswordEncoder.encodePassword(rawPassword.toString(), salt);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (StringUtils.equals("token", rawPassword) && StringUtils.equals(rawPassword, encodedPassword)) {
            return true;
        }
//        return md5PasswordEncoder
//            .isPasswordValid(encodedPassword, rawPassword.toString(), salt);
        return md5PasswordEncoder
            .isPasswordValid(encodedPassword, RSAUtils.decryptDataOnJava(rawPassword.toString()), salt);
    }
}
