package cn.gtmap.realestate.supervise.portal.utils;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.portal.model.LockUserCache;
import org.springframework.util.ObjectUtils;

import java.util.concurrent.ConcurrentMap;

/**
 * @version 1.0 2019-5-29
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
public class LockUserUtil {

    /**
     * 设置锁定用户
     * @param username
     */
    public static void setlockHandle(String username, UserAuthDTO xtUser) {
        LockUserCache lockUserCache = LockUserCache.getInstance();
        ConcurrentMap lockMap = lockUserCache.getLockUser();
        lockMap.put(username, xtUser);
    }

    /**
     * 获取锁定用户
     * @param username
     */
    public static UserAuthDTO getlockHandle(String username) {
        LockUserCache lockUserCache = LockUserCache.getInstance();
        ConcurrentMap lockMap = lockUserCache.getLockUser();
        return (UserAuthDTO) lockMap.get(username);
    }

    /**
     * 解锁用户
     * @param username
     */
    public static void unSetLockHandle(String username) {
        LockUserCache lockUserCache = LockUserCache.getInstance();
        ConcurrentMap lockMap = lockUserCache.getLockUser();
        lockMap.remove(username);
    }

    /**
     * 锁定用户
     * @param username
     */
    public static void lockHandle(String username) {
        LockUserCache lockUserCache = LockUserCache.getInstance();
        ConcurrentMap lockMap = lockUserCache.getLockUser();
        UserAuthDTO xtUser = (UserAuthDTO) lockMap.get(username);
        xtUser.setLoginLocked(true);
    }

    /**
     * 解锁用户
     * @param username
     */
    public static void unLockHandle(String username) {
        LockUserCache lockUserCache = LockUserCache.getInstance();
        ConcurrentMap lockMap = lockUserCache.getLockUser();
        UserAuthDTO xtUser = (UserAuthDTO) lockMap.get(username);
        xtUser.setLoginFailureTimes(0);
        xtUser.setLoginLocked(false);
    }

    /**
     * 判断当前用户是否被锁定
     * @param username
     */
    public static boolean isUserLocked(String username){
        LockUserCache lockUserCache = LockUserCache.getInstance();
        ConcurrentMap lockMap = lockUserCache.getLockUser();
        UserAuthDTO xtUser = (UserAuthDTO) lockMap.get(username);
        if(ObjectUtils.isEmpty(xtUser)){
            return false;
        }else{
            return xtUser.getLoginLocked();
        }
    }

}
