package cn.gtmap.realestate.supervise.portal.utils;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.portal.service.XtUserService;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

/**
 * @version 1.0 2019-5-29
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
public class LockUserFilter implements Filter {

    /**
     * MD5 盐值
     */
    private CharSequence salt;

    /**
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 连续登录失败锁定-失败次数
     */
    private Integer loginFailureLockedTimes = AppConfig.getIntProperty("login.failure.locked.times");

    @Override
    public void init(FilterConfig filterConfig) {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        if (StringUtils.equals(((HttpServletRequest) request).getMethod(), "GET")) {
            sendJsonViaReponse((HttpServletResponse) response, null, "failure");
            return;
        }
        username = RSAUtils.decryptDataOnJava(username);
        password = RSAUtils.decryptDataOnJava(password);
        // 如果含有敏感的用户名就不让登陆
        XtUserService xtUserService =
            (XtUserService) WebApplicationContextUtils
                .getWebApplicationContext(((HttpServletRequest) request).getSession().getServletContext()).getBean("xtUserService");
        String sensitiveAccount = xtUserService.getXtPropertiesByKey("sensitiveAccount");
        if (null != sensitiveAccount && sensitiveAccount.split(",").length != 0) {
            String[] sensitiveAccounts = sensitiveAccount.split(",");
            for (String sensitiveAccountTemp : sensitiveAccounts) {
                if (username.contains(sensitiveAccountTemp)) {
                    sendJsonViaReponse((HttpServletResponse) response, null, "failure");
                    return;
                }
            }
        }

        // 登录的时候先判断这个用户是不是被锁定了
        UserAuthDTO xtUserLock = LockUserUtil.getlockHandle(username);
        if (!ObjectUtils.isEmpty(xtUserLock)) {
            if (null != xtUserLock.getLoginLocked() && xtUserLock.getLoginLocked()) {
                LoginUserUtil.eliminateUser(username);
                sendJsonViaReponse((HttpServletResponse) response, xtUserLock.getLoginFailureTimes().toString(), "locked");
                return;
            }
        }

        // 如果用户没有被锁定，再执行下面的流程
        // 1.判断用户名和密码是否正确，如果错误走下面流程，如果正确直接通过
        UserAuthDTO xtUser = xtUserService.loadUserByUserName(username);
        if (ObjectUtils.isEmpty(xtUser)) {
            sendJsonViaReponse((HttpServletResponse) response, null, "failure");
            return;
        }
        Md5PasswordEncoder md5PasswordEncoder = new Md5PasswordEncoder();
        String md5Pwd = md5PasswordEncoder.encodePassword(password, salt);
        if (xtUser.getPassword().equals(md5Pwd)) {
            chain.doFilter(request, response);
        } else {
            // 1.先到 lockMap 里面找有没有这个用户涉嫌多次失败登录
            int loginFailureTimes = 1;
            if (ObjectUtils.isEmpty(xtUserLock)) {
                // 2.如果不在，将当前用户放进去
                xtUser.setLoginFailureTimes(loginFailureTimes);
                LockUserUtil.setlockHandle(xtUser.getUsername(), xtUser);
                sendJsonViaReponse((HttpServletResponse) response, loginFailureTimes, "failure");
            } else {
                // 3.如果在 lockMap 里面，看他的失败次数是否超过了限制，就设置锁定这个用户，并且返回锁定，如果没有
                loginFailureTimes = xtUserLock.getLoginFailureTimes() + 1;
                xtUserLock.setLoginFailureTimes(loginFailureTimes);
                if (loginFailureTimes >= loginFailureLockedTimes) {
                    xtUserLock.setLoginLocked(true);
                    xtUserLock.setLockDate(new Date());
                    LoginUserUtil.eliminateUser(username);
                    sendJsonViaReponse((HttpServletResponse) response, loginFailureTimes, "locked");
                } else {
                    sendJsonViaReponse((HttpServletResponse) response, loginFailureTimes, "failure");
                }
            }
        }
    }

    @Override
    public void destroy() {

    }

    /**
     * 通过 HttpServletResponse 发送 json
     *
     * @param response
     * @param data
     */
    private void sendJsonViaReponse(HttpServletResponse response, Object data, String msg) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        JSONObject res = new JSONObject();
        if (!ObjectUtils.isEmpty(data)) {
            res.put("times", data);
        }
        res.put("msg", msg);
        try {
            PrintWriter out = response.getWriter();
            out.append(res.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}