package cn.gtmap.realestate.supervise.portal.service.impl;

import cn.gtmap.realestate.supervise.entity.*;
import cn.gtmap.realestate.supervise.portal.dao.RoleResourceMapper;
import cn.gtmap.realestate.supervise.portal.dao.XtRegionMapper;
import cn.gtmap.realestate.supervise.portal.dao.XtUserMapper;
import cn.gtmap.realestate.supervise.portal.service.XtUserService;
import cn.gtmap.realestate.supervise.portal.utils.StringUrlUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;

/**
 * @author zhangyu
 * @version 1.0, 2017/6/19
 * @description 系统用户服务实现类
 */
@Service
public class XtUserServiceImpl implements XtUserService {


    @Autowired
    private XtUserMapper xtUserMapper;

    @Autowired
    private RoleResourceMapper roleResourceMapper;

    @Autowired
    private XtRegionMapper xtRegionMapper;

    /**
     * 根据username 获取唯一用户
     * @param username
     * @return
     */
    @Override
    public UserAuthDTO loadUserByUserName(String username) {
        XtUser xtUser = xtUserMapper.loadUserByUserName(username);
        if(ObjectUtils.isEmpty(xtUser)){
            return null;
        }
        UserAuthDTO userAuthDto = new UserAuthDTO();
        userAuthDto.setXtUser(xtUser);
        userAuthDto.setUsername(xtUser.getLoginName());
        userAuthDto.setPassword(xtUser.getLoginPassword());
        userAuthDto.setAccountNonExpired(true);
        userAuthDto.setAccountNonLocked(true);
        userAuthDto.setCredentialsNonExpired(true);
        userAuthDto.setEnabled(true);
        return userAuthDto;
    }

    /**
     * 根据username 获取用户资源权限
     * @param userId
     * @return
     */
    @Override
    public Set<GrantedAuthority> loadUserAuthoritiesByUserName(String userId) {
        if(StringUtils.isEmpty(userId)){
            return null;
        }
        Set<GrantedAuthority> authSet = new HashSet<>();
        List<XtRole> xtRoleList = roleResourceMapper.getRoleByUserName(userId);
        if(CollectionUtils.isNotEmpty(xtRoleList)){
            for(XtRole xr : xtRoleList){
                authSet.add( new SimpleGrantedAuthority(xr.getRoleNo()));
            }
        }
        return authSet;
    }

    @Override
    public LinkedHashMap<String, LinkedHashMap<String, XtResource>> loadUserResourcesByUserId(String userId,String token) {
        if(StringUtils.isEmpty(userId)){
            return null;
        }
        List<XtRole> xtRoleList = roleResourceMapper.getRoleByUserName(userId);

        //获取当前用户所具有的菜单权限
        LinkedHashMap<String, LinkedHashMap<String, XtResource>> xtResourceMap;
        List<XtResource> allResources = new ArrayList<>();
        List<XtResource> singleResources;
        for(XtRole xtRole : xtRoleList){
            singleResources = roleResourceMapper.getResourceByRole(xtRole.getRoleId());
            allResources.addAll(singleResources);
        }
        //根据系统去重
        xtResourceMap = distinkResource(allResources);

        //加载资源的子资源
        List<XtResource> childXtResources;
        XtResource xtResource;
        LinkedHashMap<String, XtResource> singleResourceMap;
        for(String key : xtResourceMap.keySet()){
            singleResourceMap = xtResourceMap.get(key);
            for(String resourceId : singleResourceMap.keySet()){
                childXtResources = findChildResource(resourceId,userId,token);
                xtResource = singleResourceMap.get(resourceId);
                xtResource.setResourceUrl(StringUrlUtil.handleUrl(xtResource.getResourceUrl(),token));
                if(CollectionUtils.isNotEmpty(childXtResources)){
                    xtResource.setChildResources(childXtResources);
                } else {
                    //没有子资源加载按钮权限
                    List<XtButton> buttons = roleResourceMapper.getButtonByResourceId(resourceId);
                    if(CollectionUtils.isNotEmpty(buttons)){
                        xtResource.setXtButtons(handleButtons(buttons));
                    }
                }
                singleResourceMap.put(resourceId,xtResource);
            }
        }

        return xtResourceMap;
    }

    /**
     * 资源去重
     * @param allResources 所有的资源
     * @return 去重后的资源
     */
    private  LinkedHashMap<String, LinkedHashMap<String, XtResource>> distinkResource(List<XtResource> allResources){
        LinkedHashMap<String, LinkedHashMap<String, XtResource>> xtResourceMap = new LinkedHashMap<>();
        //根据系统去重
        LinkedHashMap<String, XtResource> singleResourceMap;
        if(CollectionUtils.isNotEmpty(allResources)){
            for(XtResource xtResource : allResources){
                if(StringUtils.isNotBlank(xtResource.getParResourceId())){
                    continue;
                }
                if(StringUtils.isNotBlank(xtResource.getGroupNo())) {
                    if (xtResourceMap.containsKey(xtResource.getGroupNo())) {
                        singleResourceMap = xtResourceMap.get(xtResource.getGroupNo());
                        if(!singleResourceMap.containsKey(xtResource.getResourceId())){
                            singleResourceMap.put(xtResource.getResourceId(),xtResource);
                        }
                    } else {
                        singleResourceMap = new LinkedHashMap<>();
                        singleResourceMap.put(xtResource.getResourceId(),xtResource);
                        xtResourceMap.put(xtResource.getGroupNo(),singleResourceMap);
                    }
                }
            }
        }
        return xtResourceMap;
    }

    /**
     * 获取子资源
     * @param ResourceId 父资源ID
     * @param token token
     * @return 子资源列表
     */
    public List<XtResource> findAdminChildResource(String ResourceId,String token){
        List<XtResource> xtResources = roleResourceMapper.getAdminResourceByParent(ResourceId);
        if(CollectionUtils.isNotEmpty(xtResources)){
            for(XtResource xtResource1 : xtResources){
                xtResource1.setResourceUrl(StringUrlUtil.handleUrl(xtResource1.getResourceUrl(),token));
                List<XtResource> childXtResources = findAdminChildResource(xtResource1.getResourceId(), token);
                if(CollectionUtils.isNotEmpty(childXtResources)){
                    xtResource1.setChildResources(childXtResources);
                }else{
                    //没有子资源加载按钮权限
                    List<XtButton> buttons = roleResourceMapper.getButtonByResourceId(xtResource1.getResourceId());
                    if(CollectionUtils.isNotEmpty(buttons)){
                        xtResource1.setXtButtons(handleButtons(buttons));
                    }
                }
            }
        }
        return xtResources;
    }

    /**
     * 获取子资源
     * @param ResourceId 父资源ID
     * @param userId 用户ID
     * @param token token
     * @return 子资源列表
     */
    public List<XtResource> findChildResource(String ResourceId,String userId,String token){
        Map<String,String> paraMap = new HashMap<>();
        paraMap.put("parResourceId",ResourceId);
        if(StringUtils.isNotBlank(userId)){
            paraMap.put("userId",userId);
        }
        List<XtResource> xtResources = roleResourceMapper.getResourceByParent(paraMap);
        if(CollectionUtils.isNotEmpty(xtResources)){
            for(XtResource xtResource1 : xtResources){
                xtResource1.setResourceUrl(StringUrlUtil.handleUrl(xtResource1.getResourceUrl(),token));
               List<XtResource> childXtResources = findChildResource(xtResource1.getResourceId(),userId,token);
                if(CollectionUtils.isNotEmpty(childXtResources)){
                    xtResource1.setChildResources(childXtResources);
                }else{
                    //没有子资源加载按钮权限
                    List<XtButton> buttons = roleResourceMapper.getButtonByResourceId(xtResource1.getResourceId());
                    if(CollectionUtils.isNotEmpty(buttons)){
                        xtResource1.setXtButtons(handleButtons(buttons));
                    }
                }
            }
        }
        return xtResources;
    }

    /**
     *
     * @param token
     * @return
     */
    public LinkedHashMap<String, LinkedHashMap<String, XtResource>> findAdminResource(String token){
        List<XtResource> singleResources = roleResourceMapper.getResourceByAdmin();
        List<XtResource> childXtResources;
        XtResource xtResource;
        LinkedHashMap<String, LinkedHashMap<String, XtResource>> xtResourceMap  = distinkResource(singleResources);
        LinkedHashMap<String, XtResource> singleResourceMap;
        for(String key : xtResourceMap.keySet()){
            singleResourceMap = xtResourceMap.get(key);
            for(String resourceId : singleResourceMap.keySet()){
                childXtResources = findAdminChildResource(resourceId,token);
                xtResource = singleResourceMap.get(resourceId);
                xtResource.setResourceUrl(StringUrlUtil.handleUrl(xtResource.getResourceUrl(),token));
                if(CollectionUtils.isNotEmpty(childXtResources)){
                    xtResource.setChildResources(childXtResources);
                }
                singleResourceMap.put(resourceId,xtResource);
            }
        }
        return xtResourceMap;
    }

    @Override
    public  List<Map<String, Object>> loadUserMaxRegionByUserId(String userId) {
        List<XtRole> xtRoleList = roleResourceMapper.getRoleByUserName(userId);
        if(CollectionUtils.isNotEmpty(xtRoleList)){
            List<XtRegion> xtRegions;
            List<XtRegion> allRegions = new ArrayList<>();
            Map<String,XtRegion> xtRegionMap = new HashMap<>();
            for(XtRole xtRole : xtRoleList){
                xtRegions = xtRegionMapper.getRegionByRole(xtRole.getRoleId());
                if(CollectionUtils.isNotEmpty(xtRegions)){
                    for(XtRegion xtRegion : xtRegions){
                        xtRegionMap.put(xtRegion.getQhdm(),xtRegion);
                    }
                }
                allRegions.addAll(xtRegions);
            }
            List<Map<String, Object>> fxtRegionMaps = new ArrayList<>();
            Map<String, Object> fxtRegionMap;
            //取出最上级的区县
            if(CollectionUtils.isNotEmpty(allRegions)){
                for(XtRegion xtRegion : allRegions){
                    if(!xtRegionMap.containsKey(xtRegion.getFdm())){
                        fxtRegionMap = new LinkedHashMap<>();
                        fxtRegionMap.put("level",xtRegion.getQhjb());
                        fxtRegionMap.put("qhdm",xtRegion.getQhdm());
                        fxtRegionMap.put("qhmc",xtRegion.getQhmc());
                        fxtRegionMaps.add(fxtRegionMap);
                    }
                }
            }
            return fxtRegionMaps;
        }
        return null;
    }


    private static String handleButtons(List<XtButton> buttons){
        StringBuilder sb = new StringBuilder("");
        if(CollectionUtils.isNotEmpty(buttons)){
            for(XtButton button : buttons){
                sb.append(button.getButtonCode()).append(",");
            }
        }
        return sb.toString();
    }

    @Override
    public List<Map> getAllXtUser(){
        return xtUserMapper.getAllXtUser();
    }

    @Override
    public String getXtPropertiesByKey(String propertiesKey) {
        return xtUserMapper.getXtPropertiesByKey(propertiesKey);
    }

}
