package cn.gtmap.realestate.supervise.portal.service.impl;

import cn.gtmap.realestate.supervise.entity.XtRole;
import cn.gtmap.realestate.supervise.portal.dao.XtRoleMapper;
import cn.gtmap.realestate.supervise.portal.service.XtRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhangyu
 * @version 1.0, 2017/5/25
 * @description 系统角色服务实现类
 */
@Service
public class XtRoleServiceImpl implements XtRoleService {


    @Autowired
    private XtRoleMapper xtRoleMapper;


    @Override
    public int addRole(XtRole xtRole) {
        return xtRoleMapper.addRole(xtRole);
    }

    @Override
    public int updateRole(XtRole xtRole) {
        return xtRoleMapper.updateByRoleId(xtRole);
    }

    @Override
    public int deleteRole(String roleId) {
        return xtRoleMapper.delSelectByRoleId(roleId);
    }

    @Override
    public int delSelectByRoleId(String selectDel) {
        return xtRoleMapper.delSelectByRoleId(selectDel);
    }

    @Override
    public String getRoleNameById(String roleId) {
        return xtRoleMapper.getRoleNameById(roleId);
    }
}
