package cn.gtmap.realestate.supervise.portal.service.impl;

import cn.gtmap.realestate.supervise.entity.XtResource;
import cn.gtmap.realestate.supervise.entity.XtResourceButtonRel;
import cn.gtmap.realestate.supervise.portal.dao.XtResourceMapper;
import cn.gtmap.realestate.supervise.portal.service.XtResourceService;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhangyu
 * @version 1.0, 2017/5/25
 * @description 系统角色服务实现类
 */
@Transactional
@Service
public class XtResourceServiceImpl implements XtResourceService {


    @Autowired
    private XtResourceMapper xtResourceMapper;

    @Override
    public int addResource(XtResource xtResource) {
        return xtResourceMapper.addResource(xtResource);
    }

    @Override
    public int updateResource(Map map,String resourceId,String defaultShow) {
        if(StringUtils.equals("1",defaultShow)){
            XtResource xtResourceBottom = xtResourceMapper.getResourceById(resourceId);
            if(StringUtils.isNotBlank(xtResourceBottom.getParResourceId())){
                Map<String, Object> paramBottom = new HashMap<>();
                paramBottom.put("resourceId", xtResourceBottom.getParResourceId());
                paramBottom.put("defaultShow", map.get("defaultShow"));
                xtResourceMapper.updateResource(paramBottom);
                XtResource xtResourceMid = xtResourceMapper.getResource(paramBottom);
                if(StringUtils.isNotBlank(xtResourceMid.getParResourceId())){
                    Map<String, Object> paramMid = new HashMap<>();
                    paramMid.put("resourceId", xtResourceMid.getParResourceId());
                    paramMid.put("defaultShow", map.get("defaultShow"));
                    xtResourceMapper.updateResource(paramMid);
                }
            }
        }
        return xtResourceMapper.updateResource(map);
    }

    @Override
    public int delSelectByResourceId(String resourceId) {
        return xtResourceMapper.delSelectByResourceId(resourceId);
    }

    @Override
    public XtResource getResourceById(String resourceId) {
        return xtResourceMapper.getResourceById(resourceId);
    }

    @Override
    public List getChildNodes(Map map) {
        return xtResourceMapper.getChildNodes(map);
    }

    @Override
    public int updateParResourceId(Map map) {
        return xtResourceMapper.updateParResourceId(map);
    }

    @Override
    public List<Map> getButtonsByres(Map map){
        return xtResourceMapper.getButtonsByres(map);
    }

    @Override
    public int saveRBrels(XtResourceButtonRel rel){
        return xtResourceMapper.saveRBrels(rel);
    }

    @Override
    @Transactional
    public synchronized void saveButtons(String btnIds,String resourceId){
        HashMap paraMap = new HashMap();
        paraMap.put("resourceId",resourceId);
        xtResourceMapper.delRBrelsByresId(paraMap);
        if (StringUtils.isNotBlank(btnIds)){
            String[] btnIdsArray = btnIds.split(",");
            List<XtResourceButtonRel> xtResourceButtonRels = new ArrayList<>();
            for(String btnId : btnIdsArray){
                XtResourceButtonRel xtResourceButtonRel = null;
                if(StringUtils.isNotBlank(btnId)){
                    xtResourceButtonRel = new XtResourceButtonRel();
                    xtResourceButtonRel.setRbrid(UUIDGenerator.generate18());
                    xtResourceButtonRel.setButtonId(btnId);
                    xtResourceButtonRel.setResourceId(resourceId);
                    xtResourceButtonRels.add(xtResourceButtonRel);
                }
                saveRBrels(xtResourceButtonRel);
            }
        }
    }
}
