package cn.gtmap.realestate.supervise.portal.service.impl;

import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.portal.dao.XtRegionMapper;
import cn.gtmap.realestate.supervise.portal.service.XtRegionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/23
 * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
 * @description 部门信息接口实现
 */
@Service
public class XtRegionServiceImpl implements XtRegionService {


    @Autowired
    XtRegionMapper xtRegionMapper;


    /**
     * 查询Organ部门信息
     * @param map
     * @return XtOrgan
     */
    @Override
    public XtRegion getXzqh(Map map){
        return xtRegionMapper.getXzqh(map);
    }

    /**
     * 删除Organ部门信息
     * @param map
     * @return
     */
    @Override
    public void delXzqhByIds(Map map){
         xtRegionMapper.delXzqhByIds(map);
    }

    public void updateParentRegin(String fdm){
        xtRegionMapper.updateParentRegin(fdm);
    }

    @Override
    public List<String> getXzqhsByRoleId(Map roleid){
        return xtRegionMapper.getXzqhsByRoleId(roleid);
    }

    /**
     * 根据fdm 获取子行政区划
     * @param fdmAndlevel
     * @return
     */
    @Override
    public List<Map<String,Object>> getChildNodes(Map fdmAndlevel){
        if (fdmAndlevel != null)
            return xtRegionMapper.getChildNodes(fdmAndlevel);
        else
            return  null;
    }


    /**
     * 根据 qhdmOrQhmc 获取子行政区划
     * @param qhdmOrQhmc
     * @return
     */
    @Override
    public List<Map<String,Object>> getXzqhByPage(Map qhdmOrQhmc){
        return xtRegionMapper.getXzqhByPage(qhdmOrQhmc);
    }
}
