package cn.gtmap.realestate.supervise.portal.service.impl;
import cn.gtmap.realestate.supervise.entity.XtDate;
import cn.gtmap.realestate.supervise.portal.dao.XtDateMapper;
import cn.gtmap.realestate.supervise.portal.service.XtDateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

;


/**
 * @author wangyang
 * @version 1.0, 2017/8/6
 * @description  系统日历的实现接口
 */

@Service
public class XtDateServiceImpl implements XtDateService {

        @Autowired
      private XtDateMapper em;


    /**
     * 插入所选年份的信息
     */
    @Override
    public void insertEveryDay(List<XtDate> everydaylist) {
        em.insertEveryDay(everydaylist);
    }

    /**
     *   查询系统当月的信息
     */
    @Override
    public List<XtDate> selectMonthDay() {
        return em.selectMonthDay();
    }

    /**
     *更新具体一天的信息
     */
    @Override
    public void updateDateType( String id,  Integer xttype, String xttext) {
           em.updateDateType(id,xttype,xttext);
    }

    /**
     *通过月份获得当月的的所有信息
     */
    @Override
    public List<XtDate> selectDayByMonth( String yearandmonth) {
        return em.selectDayByMonth(yearandmonth);
    }

    /**
     *通过具体时间获得相对应的一条记录
     */
    @Override
    public XtDate selectOneDayByDate( Date sdate) {
        return em.selectOneDayByDate(sdate);
    }

    /**
     *通过id获得相对应的一条记录
     */
    @Override
    public XtDate selectOneDayById(String id) {
        return em.selectOneDayById(id);
    }


}
