package cn.gtmap.realestate.supervise.portal.service.impl;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.portal.service.SysAuthorService;
import cn.gtmap.realestate.supervise.portal.utils.LoginUserUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * @author hqz
 * @version 1.0, 2017/6/7
 * @description 对外用户及权限接口
 */
@Service
public class SysAuthorServiceImpl implements SysAuthorService {


    /**
     * 根据SSOID获取当前登录的用户
     * @param ssoID cookie的value
     * @return 当前登录用户信息
     */
    @Override
    public UserAuthDTO getSysUserBySSOID(String ssoID) {
        UserAuthDTO userAuthDTO = null;
        if(StringUtils.isNotBlank(ssoID)){
            userAuthDTO = LoginUserUtil.getLoginUserMap(ssoID);
        }
        return userAuthDTO;
    }
}
