package cn.gtmap.realestate.supervise.portal.service.impl;

import cn.gtmap.realestate.supervise.entity.XtResource;
import cn.gtmap.realestate.supervise.entity.XtRole;
import cn.gtmap.realestate.supervise.portal.dao.RoleResourceMapper;
import cn.gtmap.realestate.supervise.portal.model.RoleResourceDTO;
import cn.gtmap.realestate.supervise.portal.service.RoleResourceService;
import cn.gtmap.realestate.supervise.portal.utils.StringUrlUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hqz
 * @version 1.0, 2017/5/26
 * @description 资源权限实现类
 */
@Service
public class RoleResourceServiceImpl implements RoleResourceService {


    @Autowired
    private RoleResourceMapper roleResourceMapper;

    private String role_admin = AppConfig.getProperty("role.admin");


    /**
     * 查出所有的资源对应的权限
     * @return
     */
    @Override
    public List<RoleResourceDTO> findRoleResourceDTO(String groupNo) {
        List<RoleResourceDTO> list = new ArrayList<>();
        List<XtResource> xtResourceList = roleResourceMapper.getAllResource(groupNo);
        Map<String,XtRole> distinkMap;
        RoleResourceDTO roleResourceDTO;
        if(CollectionUtils.isNotEmpty(xtResourceList)){
            for(XtResource xr : xtResourceList){
                distinkMap = new HashMap<>();
                List<XtRole> xtRoleList = roleResourceMapper.getRoleByResource(xr.getResourceId());
                if(CollectionUtils.isNotEmpty(xtRoleList)){
                    for(XtRole xtRole : xtRoleList){
                        if(distinkMap.containsKey(xtRole.getRoleNo())){
                            continue;
                        }else{
                            xr.setResourceUrl(StringUrlUtil.splitUrl(xr.getResourceUrl()));
                            roleResourceDTO = new RoleResourceDTO();
                            roleResourceDTO.setInterceptUrl(xr.getResourceUrl());
                            roleResourceDTO.setRoleNo(xtRole.getRoleNo());
                            roleResourceDTO.setXtRole(xtRole);
                            roleResourceDTO.setXtResource(xr);
                            list.add(roleResourceDTO);
                            distinkMap.put(xtRole.getRoleNo(),xtRole);
                        }
                    }
                }
            }
        }
        return list;
    }

    @Override
    public List<RoleResourceDTO> findRoleResourceDTObyUrl(String url, String groupNo) {
        List<RoleResourceDTO> list = new ArrayList<>();
        Map<String,String> queryMap = new HashMap<>();
        if(StringUtils.isNotBlank(url)){
            queryMap.put("url",url);
        }
        if(StringUtils.isNotBlank(groupNo)){
            queryMap.put("groupNo",groupNo);
        }
        List<XtResource> xtResourceList = roleResourceMapper.getResourceByMap(queryMap);
        Map<String,XtRole> distinkMap;
        RoleResourceDTO roleResourceDTO;
        if(CollectionUtils.isNotEmpty(xtResourceList)){
            for(XtResource xr : xtResourceList){
                distinkMap = new HashMap<>();
                List<XtRole> xtRoleList = roleResourceMapper.getRoleByResource(xr.getResourceId());
                if(CollectionUtils.isNotEmpty(xtRoleList)){
                    for(XtRole xtRole : xtRoleList){
                        if(distinkMap.containsKey(xtRole.getRoleNo())){
                            continue;
                        }else{
                            roleResourceDTO = new RoleResourceDTO();
                            roleResourceDTO.setInterceptUrl(xr.getResourceUrl());
                            roleResourceDTO.setRoleNo(xtRole.getRoleNo());
                            roleResourceDTO.setXtRole(xtRole);
                            roleResourceDTO.setXtResource(xr);
                            list.add(roleResourceDTO);
                            distinkMap.put(xtRole.getRoleNo(),xtRole);
                        }
                    }
                } else {
                    roleResourceDTO = new RoleResourceDTO();
                    roleResourceDTO.setInterceptUrl(xr.getResourceUrl());
                    roleResourceDTO.setRoleNo(role_admin);
                    roleResourceDTO.setXtRole(null);
                    roleResourceDTO.setXtResource(xr);
                    list.add(roleResourceDTO);
                    distinkMap.put(role_admin,null);
                }
            }
        }
        return list;
    }

}
