package cn.gtmap.realestate.supervise.portal.service.impl;

import cn.gtmap.realestate.supervise.portal.dao.FetchResourceMapper;
import cn.gtmap.realestate.supervise.portal.service.FetchResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by 徐涛 on 2018-7-20.
 */
@Service
public class FetchResourceServiceImpl implements FetchResourceService {

    private static final Logger LOGGER = LoggerFactory.getLogger(FetchResourceServiceImpl.class);

    @Autowired
    private FetchResourceMapper fetchResourceMapper;


    @Override
    public List<Map<String, Object>> FetchResourceByLoginName(String loginName, String groupNo) {
        List<Map<String, Object>> dataList = new ArrayList<>();
        try {
            dataList = fetchResourceMapper.FetchResourceByLoginName(loginName, groupNo);
        } catch (DataAccessException e) {
            LOGGER.error("DataAccessException", e);
        }
        return dataList;
    }
}
