package cn.gtmap.realestate.supervise.portal.service;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtResource;
import org.springframework.security.core.GrantedAuthority;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author hqz
 * @version 1.0, 2017/5/25
 * @description 系统用户服务接口
 */
public interface XtUserService  {

    /**
     * 根据username 获取唯一用户
     * @param username
     * @return
     */
    UserAuthDTO loadUserByUserName(String username);


    /**
     * 根据username 获取用户资源权限
     * @param userId
     * @return
     */
    Set<GrantedAuthority> loadUserAuthoritiesByUserName(String userId);

    /**
     * 根据登录用户获取用户当前的登录权限
     * @param userId
     * @return 系统及其所具有的角色
     */
    LinkedHashMap<String, LinkedHashMap<String, XtResource>> loadUserResourcesByUserId(String userId,String token);

    /**
     * 获取admin权限的所有资源和菜单
     * @return admin权限所具有的菜单资源
     */
    LinkedHashMap<String, LinkedHashMap<String, XtResource>> findAdminResource(String token);

    /**
     * 根据当前用户获取用户所具有的最高行政区权限
     * @param userId 用户ID
     * @return 最高行政区权限
     */
    List<Map<String, Object>>  loadUserMaxRegionByUserId(String userId);


    List<Map> getAllXtUser();

    /**
     * 根据key值获取参数值
     * @param propertiesKey
     * @return
     */
    String getXtPropertiesByKey(String propertiesKey);

}
