package cn.gtmap.realestate.supervise.portal.service;

import cn.gtmap.realestate.supervise.entity.XtRegion;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/23
 * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
 * @description 部门信息接口
 */
public interface XtRegionService {


    /**
     * 查询Xzqh行政区划信息
     * @param map
     * @return XtXzqh
     */
    XtRegion getXzqh(Map map);

    /**
     * 删除Xzqh行政区划信息
     * @param map
     * @return
     */
    void delXzqhByIds(Map map);

    void updateParentRegin(String fdm);

    /**
     * 根据roleID 获取行政区划
     * @param roleid
     * @return
     */
    List<String> getXzqhsByRoleId(Map roleid);

    /**
     * 根据fdm 获取子行政区划
     * @param fdm
     * @return
     */
    List<Map<String,Object>> getChildNodes(Map fdm);


    /**
     * 根据 qhdmOrQhmc 获取子行政区划
     * @param qhdmOrQhmc
     * @return
     */
    List<Map<String,Object>> getXzqhByPage(Map qhdmOrQhmc);

}
