package cn.gtmap.realestate.supervise.portal.service;

import cn.gtmap.realestate.supervise.entity.XtDate;
import java.util.Date;
import java.util.List;

/**
 * @author wangyang
 * @version 1.0, 2017/8/6
 * @description  系统日历的接口
 */

public  interface XtDateService {
    /**
     * 插入所选年份的信息
     */
    void insertEveryDay(List<XtDate> everydaylist);

    /**
     * 查询系统当月的信息
     */
    List<XtDate> selectMonthDay();

    /**
     * 更新具体一天的信息
     */
    void  updateDateType(String id,Integer xttype, String xttext);

    /**
     *通过月份获得当月的的所有信息
     */
    List<XtDate>  selectDayByMonth(String yearandmonth);

    /**
     *通过具体时间获得相对应的一条记录
     */
    XtDate  selectOneDayByDate(Date sdate);

    /**
     *通过id获得相对应的一条记录
     */
    XtDate  selectOneDayById(String id);
}
